/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.OutputStream;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.StreamProgressUpdater;
import org.openstreetmap.josm.tools.I18n;

public class ProgressOutputStream
extends OutputStream {
    private final StreamProgressUpdater updater;
    private final OutputStream out;
    private final boolean finishOnClose;

    public ProgressOutputStream(OutputStream out, long size, ProgressMonitor progressMonitor, boolean finishOnClose) {
        this(out, size, progressMonitor, I18n.tr("Uploading data ...", new Object[0]), finishOnClose);
    }

    public ProgressOutputStream(OutputStream out, long size, ProgressMonitor progressMonitor, String message, boolean finishOnClose) {
        this.updater = new StreamProgressUpdater(size, progressMonitor != null ? progressMonitor : NullProgressMonitor.INSTANCE, message);
        this.out = out;
        this.finishOnClose = finishOnClose;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.updater.advanceTicker(len);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.updater.advanceTicker(1);
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.close();
        }
        finally {
            if (this.finishOnClose) {
                this.updater.finishTask();
            }
        }
    }
}

