/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.cache;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.data.cache.CacheEntry;

public class BufferedImageCacheEntry
extends CacheEntry {
    private static final long serialVersionUID = 1L;
    private volatile transient BufferedImage img;
    private volatile transient boolean imageLoaded;

    public BufferedImageCacheEntry(byte[] content) {
        super(content);
    }

    public static BufferedImageCacheEntry pngEncoded(BufferedImage img) {
        BufferedImageCacheEntry bufferedImageCacheEntry;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", output);
            bufferedImageCacheEntry = new BufferedImageCacheEntry(output.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        output.close();
        return bufferedImageCacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImage() throws IOException {
        if (this.imageLoaded) {
            return this.img;
        }
        BufferedImageCacheEntry bufferedImageCacheEntry = this;
        synchronized (bufferedImageCacheEntry) {
            if (this.imageLoaded) {
                return this.img;
            }
            byte[] content = this.getContent();
            if (content.length > 0) {
                this.img = ImageIO.read(new ByteArrayInputStream(content));
                this.imageLoaded = true;
            }
        }
        return this.img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        BufferedImageCacheEntry bufferedImageCacheEntry = this;
        synchronized (bufferedImageCacheEntry) {
            if (this.content == null && this.img != null) {
                throw new AssertionError((Object)"Trying to serialize (save to disk?) an BufferedImageCacheEntry that was converted to BufferedImage and no raw data is present anymore");
            }
            out.writeObject(this);
            if (this.img != null) {
                this.content = null;
            }
        }
    }
}

