/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.tools.Utils;

public class ProjectionBounds {
    public double minEast;
    public double minNorth;
    public double maxEast;
    public double maxNorth;

    public ProjectionBounds(EastNorth min, EastNorth max) {
        this.minEast = min.east();
        this.minNorth = min.north();
        this.maxEast = max.east();
        this.maxNorth = max.north();
    }

    public ProjectionBounds(EastNorth p) {
        this.minEast = this.maxEast = p.east();
        this.minNorth = this.maxNorth = p.north();
    }

    public ProjectionBounds(EastNorth center, double east, double north) {
        this.minEast = center.east() - east / 2.0;
        this.minNorth = center.north() - north / 2.0;
        this.maxEast = center.east() + east / 2.0;
        this.maxNorth = center.north() + north / 2.0;
    }

    public ProjectionBounds(double minEast, double minNorth, double maxEast, double maxNorth) {
        this.minEast = minEast;
        this.minNorth = minNorth;
        this.maxEast = maxEast;
        this.maxNorth = maxNorth;
    }

    public ProjectionBounds() {
        this.minEast = Double.POSITIVE_INFINITY;
        this.minNorth = Double.POSITIVE_INFINITY;
        this.maxEast = Double.NEGATIVE_INFINITY;
        this.maxNorth = Double.NEGATIVE_INFINITY;
    }

    public void extend(EastNorth e) {
        if (e.east() < this.minEast) {
            this.minEast = e.east();
        }
        if (e.east() > this.maxEast) {
            this.maxEast = e.east();
        }
        if (e.north() < this.minNorth) {
            this.minNorth = e.north();
        }
        if (e.north() > this.maxNorth) {
            this.maxNorth = e.north();
        }
    }

    public void extend(ProjectionBounds b) {
        if (b.minEast < this.minEast) {
            this.minEast = b.minEast;
        }
        if (b.maxEast > this.maxEast) {
            this.maxEast = b.maxEast;
        }
        if (b.minNorth < this.minNorth) {
            this.minNorth = b.minNorth;
        }
        if (b.maxNorth > this.maxNorth) {
            this.maxNorth = b.maxNorth;
        }
    }

    public EastNorth getCenter() {
        return new EastNorth((this.minEast + this.maxEast) / 2.0, (this.minNorth + this.maxNorth) / 2.0);
    }

    public String toString() {
        return "ProjectionBounds[" + this.minEast + "," + this.minNorth + "," + this.maxEast + "," + this.maxNorth + "]";
    }

    public boolean intersects(ProjectionBounds b) {
        return b.maxEast >= this.minEast && b.maxNorth >= this.minNorth && b.minEast <= this.maxEast && b.minNorth <= this.maxNorth;
    }

    public boolean contains(EastNorth en) {
        return this.minEast <= en.east() && en.east() <= this.maxEast && this.minNorth <= en.north() && en.north() <= this.maxNorth;
    }

    public EastNorth getMin() {
        return new EastNorth(this.minEast, this.minNorth);
    }

    public EastNorth getMax() {
        return new EastNorth(this.maxEast, this.maxNorth);
    }

    public boolean hasExtend() {
        return !Utils.equalsEpsilon(this.minEast, this.maxEast) || !Utils.equalsEpsilon(this.minNorth, this.maxNorth);
    }

    public double getScale(int width, int height) {
        int h;
        int w = width - 20;
        if (w < 20) {
            w = 20;
        }
        if ((h = height - 20) < 20) {
            h = 20;
        }
        double scaleX = this.getDeltaEast() / (double)w;
        double scaleY = this.getDeltaNorth() / (double)h;
        return Math.max(scaleX, scaleY);
    }

    private double getDeltaNorth() {
        return this.maxNorth - this.minNorth;
    }

    private double getDeltaEast() {
        return this.maxEast - this.minEast;
    }
}

