/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.gui.jmapviewer.interfaces.TemplatedTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;

public class TemplatedTMSTileSource
extends TMSTileSource
implements TemplatedTileSource {
    private static final String COOKIE_HEADER = "Cookie";
    private static final Pattern PATTERN_ZOOM = Pattern.compile("\\{(?:(\\d+)-)?z(?:oom)?([+-]\\d+)?}");
    private static final Pattern PATTERN_X = Pattern.compile("\\{x}");
    private static final Pattern PATTERN_Y = Pattern.compile("\\{y}");
    private static final Pattern PATTERN_Y_YAHOO = Pattern.compile("\\{!y}");
    private static final Pattern PATTERN_NEG_Y = Pattern.compile("\\{-y}");
    private static final Pattern PATTERN_QUAD = Pattern.compile("\\{quad}");
    private static final Pattern PATTERN_SWITCH = Pattern.compile("\\{switch:([^}]+)}");
    private static final Pattern PATTERN_HEADER = Pattern.compile("\\{header\\(([^,]+),([^}]+)\\)}");
    private static final Pattern PATTERN_API_KEY = Pattern.compile("\\{apikey}");
    private static final Pattern PATTERN_PARAM = Pattern.compile("\\{((?:\\d+-)?z(?:oom)?(:?[+-]\\d+)?|x|y|!y|-y|quad|switch:([^}]+))}");
    private static final Pattern[] ALL_PATTERNS = new Pattern[]{PATTERN_HEADER, PATTERN_ZOOM, PATTERN_X, PATTERN_Y, PATTERN_Y_YAHOO, PATTERN_NEG_Y, PATTERN_SWITCH, PATTERN_API_KEY, PATTERN_QUAD};
    private Random rand;
    private String[] randomParts;
    private final Map<String, String> headers = new HashMap<String, String>();
    private boolean inverse_zoom;
    private int zoom_offset;

    public TemplatedTMSTileSource(TileSourceInfo info) {
        super(info);
        String cookies = info.getCookies();
        if (cookies != null && !cookies.isEmpty()) {
            this.headers.put(COOKIE_HEADER, cookies);
        }
        this.handleTemplate(info.getId());
    }

    private void replacePattern(BiConsumer<Matcher, StringBuffer> replaceAction, Pattern ... patterns) {
        for (Pattern p : patterns) {
            StringBuffer output = new StringBuffer();
            Matcher m = p.matcher(this.baseUrl);
            while (m.find()) {
                replaceAction.accept(m, output);
            }
            m.appendTail(output);
            this.baseUrl = output.toString();
        }
    }

    private void handleTemplate(String imageryId) {
        Matcher m = PATTERN_SWITCH.matcher(this.baseUrl);
        if (m.find()) {
            this.rand = new Random();
            this.randomParts = m.group(1).split(",", -1);
        }
        this.replacePattern((matcher, output) -> {
            this.headers.put(matcher.group(1), matcher.group(2));
            matcher.appendReplacement((StringBuffer)output, "");
        }, PATTERN_HEADER);
        if (imageryId != null) {
            this.replacePattern((matcher, output) -> {
                try {
                    matcher.appendReplacement((StringBuffer)output, FeatureAdapter.retrieveApiKey(imageryId));
                }
                catch (IOException | RuntimeException e) {
                    throw new IllegalArgumentException(e);
                }
            }, PATTERN_API_KEY);
        }
        if ((m = PATTERN_ZOOM.matcher(this.baseUrl)).find()) {
            if (m.group(1) != null) {
                this.inverse_zoom = true;
                this.zoom_offset = Integer.parseInt(m.group(1));
            }
            if (m.group(2) != null) {
                String ofs = m.group(2);
                if (ofs.startsWith("+")) {
                    ofs = ofs.substring(1);
                }
                this.zoom_offset += Integer.parseInt(ofs);
            }
        }
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getTileUrl(int zoom, int tilex, int tiley) {
        StringBuffer url = new StringBuffer(this.baseUrl.length());
        Matcher matcher = PATTERN_PARAM.matcher(this.baseUrl);
        while (matcher.find()) {
            String replacement;
            switch (matcher.group(1)) {
                case "z": 
                case "zoom": {
                    replacement = Integer.toString((this.inverse_zoom ? -zoom : zoom) + this.zoom_offset);
                    break;
                }
                case "x": {
                    replacement = Integer.toString(tilex);
                    break;
                }
                case "y": {
                    replacement = Integer.toString(tiley);
                    break;
                }
                case "!y": {
                    replacement = Integer.toString((int)Math.pow(2.0, (double)zoom - 1.0) - 1 - tiley);
                    break;
                }
                case "-y": {
                    replacement = Integer.toString((int)Math.pow(2.0, zoom) - 1 - tiley);
                    break;
                }
                case "switch:": {
                    replacement = this.getRandomPart(this.randomParts);
                    break;
                }
                case "quad": {
                    replacement = TemplatedTMSTileSource.xyzToQuadKey(tilex, tiley, zoom);
                    break;
                }
                default: {
                    replacement = PATTERN_ZOOM.matcher("{" + matcher.group(1) + "}").matches() ? Integer.toString((this.inverse_zoom ? -zoom : zoom) + this.zoom_offset) : (PATTERN_SWITCH.matcher("{" + matcher.group(1) + "}").matches() ? this.getRandomPart(this.randomParts) : '{' + matcher.group(1) + '}');
                }
            }
            matcher.appendReplacement(url, replacement);
        }
        matcher.appendTail(url);
        return url.toString().replace(" ", "%20");
    }

    private static String xyzToQuadKey(int x, int y, int z) {
        char[] string = new char[z];
        for (int i = z; i > 0; --i) {
            int digit = 48;
            int mask = 1 << i - 1;
            if ((x & mask) != 0) {
                digit = (char)(digit + 1);
            }
            if ((y & mask) != 0) {
                digit = (char)(digit + 2);
            }
            string[z - i] = digit;
        }
        return String.valueOf(string);
    }

    protected String getRandomPart(String[] parts) {
        return parts[this.rand.nextInt(parts.length)];
    }

    public static void checkUrl(String url) {
        assert (url != null && !"".equals(url)) : "URL cannot be null or empty";
        Matcher m = Pattern.compile("\\{[^}]*}").matcher(url);
        while (m.find()) {
            boolean isSupportedPattern = Arrays.stream(ALL_PATTERNS).anyMatch(pattern -> pattern.matcher(m.group()).matches());
            if (isSupportedPattern) continue;
            throw new IllegalArgumentException(m.group() + " is not a valid TMS argument. Please check this server URL:\n" + url);
        }
    }
}

