context("Parallelism")

parcmp<-function(...){
 set.seed(3)
 rFerns(...,threads=1)->serial
 set.seed(3)
 rFerns(...,threads=2)->para
 serial$timeTaken<-para$timeTaken<-NULL
 expect_equal(serial,para)
}

test_that("Simple training in parallel and serial modes yield the same model",{
 parcmp(Species~.,data=iris)
})

test_that("Multi-class training in parallel and serial modes yield the same model",{
 cbind(
  setosa=rep(c(T,F,F),each=50),
  versicolor=rep(c(F,T,F),each=50),
  virginica=rep(c(F,F,T),each=50))->iris_multi_decision
 parcmp(iris[,-5],iris_multi_decision)
})

test_that("Importance in parallel and serial modes is the same",{
 parcmp(Species~.,data=iris,imp=TRUE)
 parcmp(Species~.,data=iris,imp='sha')
})

test_that("Threads argument is validated properly",{
 expect_error(rFerns(iris[,-5],iris[,5],threads=-1),"Invalid threads argument")
 expect_error(rFerns(iris[,-5],iris[,5],threads=c(2,3,19)),"Invalid threads argument")
})
