/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.Alphabet;
import com.thaiopensource.relaxng.pattern.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.NullNameClass;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RestrictionViolationException;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ElementPattern
extends Pattern {
    private Pattern p;
    private final NameClass origNameClass;
    private NameClass nameClass;
    private boolean expanded = false;
    private boolean checkedRestrictions = false;
    private final Locator loc;

    ElementPattern(NameClass nameClass, Pattern pattern, Locator locator) {
        super(false, 1, ElementPattern.combineHashCode(23, nameClass.hashCode(), pattern.hashCode()));
        this.nameClass = nameClass;
        this.origNameClass = nameClass;
        this.p = pattern;
        this.loc = locator;
    }

    @Override
    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        if (alphabet != null) {
            alphabet.addElement(this.origNameClass);
        }
        if (this.checkedRestrictions) {
            return;
        }
        switch (n) {
            case 7: {
                throw new RestrictionViolationException("data_except_contains_element");
            }
            case 6: {
                throw new RestrictionViolationException("list_contains_element");
            }
            case 5: {
                throw new RestrictionViolationException("attribute_contains_element");
            }
        }
        this.checkedRestrictions = true;
        try {
            this.p.checkRestrictions(1, new DuplicateAttributeDetector(), null);
        }
        catch (RestrictionViolationException restrictionViolationException) {
            this.checkedRestrictions = false;
            restrictionViolationException.maybeSetLocator(this.loc);
            throw restrictionViolationException;
        }
    }

    @Override
    Pattern expand(SchemaPatternBuilder schemaPatternBuilder) {
        if (!this.expanded) {
            this.expanded = true;
            this.p = this.p.expand(schemaPatternBuilder);
            if (this.p.isNotAllowed()) {
                this.nameClass = new NullNameClass();
            }
        }
        return this;
    }

    @Override
    boolean samePattern(Pattern pattern) {
        if (!(pattern instanceof ElementPattern)) {
            return false;
        }
        ElementPattern elementPattern = (ElementPattern)pattern;
        return this.nameClass.equals(elementPattern.nameClass) && this.p == elementPattern.p;
    }

    @Override
    void checkRecursion(int n) throws SAXException {
        this.p.checkRecursion(n + 1);
    }

    @Override
    <T> T apply(PatternFunction<T> patternFunction) {
        return patternFunction.caseElement(this);
    }

    void setContent(Pattern pattern) {
        this.p = pattern;
    }

    Pattern getContent() {
        return this.p;
    }

    NameClass getNameClass() {
        return this.nameClass;
    }

    Locator getLocator() {
        return this.loc;
    }
}

