# ===========================================================================
# File: default.tcl
# Target: html
#                        Created: 2010-08-29 09:51:41
#              Last modification: 2016-10-04 18:50:33
# Author: Bernard Desgraupes
# e-mail: <bdesgraupes@users.sourceforge.net>
# Copyright (c) 2010-2016 Bernard Desgraupes
# All rights reserved.
# Description: default settings for target html
# ===========================================================================

# Header keywords
# ---------------

namespace eval html {
	variable aida_head
	
# 	set aida_head(Meta)		""
	
	# Prefix of index marks
	set aida_head(IndexMark)		"AIDAIDX"
	
	# Prefix of section marks
	set aida_head(SectionMark)		"AIDASEC"
	
	# By default, enable the navigation bar in split files
	set aida_head(NavBar)			1

	# Escape opening tags in PRE environments (to prevent tags from being
	# interpreted by the browsers)
	set aida_head(EscapeVerbatim)	1
	
	##set aida_head(Charset)			utf-8
}



# Attributes
# ----------

dict set aida_attr table border 1



# Chars mapping
# -------------

array set aida_map {
    "&"     "&amp;"
    "<"     "&lt;"
    ">"     "&gt;"
    "\""    "&quot;"
    "'"     "&apos;"
}


