# ===========================================================================
# File: default.tcl
# Target: hyperref
#                        Created: 2010-10-01 16:29:24
#              Last modification: 2010-11-05 06:19:25
# Author: Bernard Desgraupes
# e-mail: <bdesgraupes@users.sourceforge.net>
# (c) Copyright: Bernard Desgraupes 2010
# All rights reserved.
# Description: default Aida settings
# ===========================================================================

# Array of header keywords
# ------------------------

namespace eval hyperref {
	variable aida_head
	
	# Read the defaults of the latex target	
	if {[catch {aida::loadTarget latex default} res]} {
		error "can't load latex target definition required by the hyperref target: $res"
	} 

	# Transfer the latex specific settings to the hyperref namespace
	array set aida_head [array get ::latex::aida_head]

	# Used to build the \\hyperbaseurl macro (can be empty)
	set aida_head(BaseUrl) ""

	# Add 'hyperref' to the list of required packages
	dict set aida_head(Packages) hyperref "hyperindex colorlinks dvips"
	
	# Define the extension of the split files in the navigation bar.
	# Typically the hyperref target produces Latex files which will be
	# converted later to pdf and the navigation is intended to operate
	# among the .pdf files, not the .tex sources.
	set aida_head(NavExtension)			".pdf"

	# By default, enable the navigation bar in split files
	set aida_head(NavBar)				1

	# # ----------------------------------------------------------------
	# # Pdf document options
	# # ----------------------------------------------------------------
	set aida_head(Bookmarks)			true
	set aida_head(BookmarksNumbered)	true
	set aida_head(BookmarksOpen)		true
	set aida_head(Creator)				"Aida"
 	set aida_head(Producer)				"Hyperref"
	
	# # ----------------------------------------------------------------
	# # Other parameters which can be defined for the \hypersetup macro.
	# # Their value can be set here or at a higher level in a configuration
	# # file like ~/.aidarc/default.tcl
	# # ----------------------------------------------------------------
	# set aida_head(Author)	""
	# set aida_head(Keywords)	""
	# set aida_head(Subject)	""
	# set aida_head(Title)	""

}

# # Unsupported:
# pdfpagemode pdfstartpage pdfstartview


# Chars mapping
# -------------
# The array aida_map is inherited from the latex target.
