/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.src;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.mod.SmaliMod;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.writer.builder.DexBuilder;
import com.android.tools.smali.dexlib2.writer.io.FileDataStore;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class SmaliBuilder {
    private static final Logger LOGGER = Logger.getLogger(SmaliBuilder.class.getName());
    private final ExtFile mSmaliDir;
    private final int mApiLevel;

    public SmaliBuilder(File smaliDir, int apiLevel) {
        this.mSmaliDir = new ExtFile(smaliDir);
        this.mApiLevel = apiLevel;
    }

    public void build(File dexFile) throws AndrolibException {
        try {
            DexBuilder dexBuilder = new DexBuilder(this.mApiLevel > 0 ? Opcodes.forApi(this.mApiLevel) : Opcodes.getDefault());
            for (String fileName : this.mSmaliDir.getDirectory().getFiles(true)) {
                this.buildFile(fileName, dexBuilder);
            }
            dexBuilder.writeTo(new FileDataStore(dexFile));
        }
        catch (DirectoryException | IOException | RuntimeException ex) {
            throw new AndrolibException("Could not smali folder: " + this.mSmaliDir.getName(), ex);
        }
    }

    private void buildFile(String fileName, DexBuilder dexBuilder) throws AndrolibException {
        Exception cause;
        boolean success;
        if (!fileName.endsWith(".smali")) {
            LOGGER.warning("Unknown file type, ignoring: " + fileName);
            return;
        }
        try {
            File inFile = new File(this.mSmaliDir, fileName);
            success = SmaliMod.assembleSmaliFile(inFile, dexBuilder, this.mApiLevel, false, false);
            cause = null;
        }
        catch (Exception ex) {
            success = false;
            cause = ex;
        }
        if (!success) {
            AndrolibException ex = new AndrolibException("Could not smali file: " + fileName);
            if (cause != null) {
                ex.initCause(cause);
            }
            throw ex;
        }
    }
}

