/*
 * Decompiled with CFR 0.152.
 */
package brut.yaml;

import brut.yaml.YamlSerializable;
import brut.yaml.YamlStringEscapeUtils;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class YamlWriter
implements Closeable {
    private static final String QUOTE = "'";
    private final PrintWriter mWriter;
    private int mIndent;

    public YamlWriter(OutputStream out) {
        this.mWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
    }

    @Override
    public void close() throws IOException {
        this.mWriter.close();
    }

    public String getIndentString() {
        return String.join((CharSequence)"", Collections.nCopies(this.mIndent, " "));
    }

    public static String escape(String value) {
        return YamlStringEscapeUtils.escapeString(value);
    }

    public void nextIndent() {
        this.mIndent += 2;
    }

    public void prevIndent() {
        if (this.mIndent != 0) {
            this.mIndent -= 2;
        }
    }

    public void writeIndent() {
        this.mWriter.print(this.getIndentString());
    }

    public void writeBool(String key, boolean value) {
        this.writeIndent();
        String val = value ? "true" : "false";
        this.mWriter.println(YamlWriter.escape(key) + ": " + val);
    }

    public void writeString(String key, String value, boolean quoted) {
        this.writeIndent();
        if (Objects.isNull(value)) {
            this.mWriter.println(YamlWriter.escape(key) + ": null");
        } else {
            if (quoted) {
                value = QUOTE + value + QUOTE;
            }
            this.mWriter.println(YamlWriter.escape(key) + ": " + YamlWriter.escape(value));
        }
    }

    public void writeString(String key, String value) {
        this.writeString(key, value, false);
    }

    public <T> void writeList(String key, List<T> list) {
        if (Objects.isNull(list)) {
            return;
        }
        this.writeIndent();
        this.mWriter.println(YamlWriter.escape(key) + ":");
        for (T item : list) {
            this.writeIndent();
            this.mWriter.println("- " + item);
        }
    }

    public <T> void writeMap(String key, Map<String, T> map) {
        if (Objects.isNull(map)) {
            return;
        }
        this.writeIndent();
        this.mWriter.println(YamlWriter.escape(key) + ":");
        this.nextIndent();
        for (String mapKey : map.keySet()) {
            this.writeString(mapKey, String.valueOf(map.get(mapKey)));
        }
        this.prevIndent();
    }

    public <T extends YamlSerializable> void writeObject(String key, T obj) {
        if (Objects.isNull(obj)) {
            return;
        }
        this.writeIndent();
        this.mWriter.println(YamlWriter.escape(key) + ":");
        this.nextIndent();
        obj.write(this);
        this.prevIndent();
    }
}

