/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.immutable;

import com.android.tools.smali.dexlib2.base.reference.BaseTypeReference;
import com.android.tools.smali.dexlib2.iface.Annotation;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.iface.Field;
import com.android.tools.smali.dexlib2.iface.Method;
import com.android.tools.smali.dexlib2.immutable.ImmutableAnnotation;
import com.android.tools.smali.dexlib2.immutable.ImmutableField;
import com.android.tools.smali.dexlib2.immutable.ImmutableMethod;
import com.android.tools.smali.dexlib2.util.FieldUtil;
import com.android.tools.smali.dexlib2.util.MethodUtil;
import com.android.tools.smali.util.ChainedIterable;
import com.android.tools.smali.util.ImmutableConverter;
import com.android.tools.smali.util.ImmutableUtils;
import com.android.tools.smali.util.IteratorUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ImmutableClassDef
extends BaseTypeReference
implements ClassDef {
    @Nonnull
    protected final String type;
    protected final int accessFlags;
    @Nullable
    protected final String superclass;
    @Nonnull
    protected final List<String> interfaces;
    @Nullable
    protected final String sourceFile;
    @Nonnull
    protected final Set<? extends ImmutableAnnotation> annotations;
    @Nonnull
    protected final SortedSet<? extends ImmutableField> staticFields;
    @Nonnull
    protected final SortedSet<? extends ImmutableField> instanceFields;
    @Nonnull
    protected final SortedSet<? extends ImmutableMethod> directMethods;
    @Nonnull
    protected final SortedSet<? extends ImmutableMethod> virtualMethods;
    private static final ImmutableConverter<ImmutableClassDef, ClassDef> CONVERTER = new ImmutableConverter<ImmutableClassDef, ClassDef>(){

        @Override
        protected boolean isImmutable(@Nonnull ClassDef item) {
            return item instanceof ImmutableClassDef;
        }

        @Override
        @Nonnull
        protected ImmutableClassDef makeImmutable(@Nonnull ClassDef item) {
            return ImmutableClassDef.of(item);
        }
    };

    public ImmutableClassDef(@Nonnull String type, int accessFlags, @Nullable String superclass, @Nullable Collection<String> interfaces, @Nullable String sourceFile, @Nullable Collection<? extends Annotation> annotations, @Nullable Iterable<? extends Field> fields, @Nullable Iterable<? extends Method> methods) {
        if (fields == null) {
            fields = Collections.emptyList();
        }
        if (methods == null) {
            methods = Collections.emptyList();
        }
        this.type = type;
        this.accessFlags = accessFlags;
        this.superclass = superclass;
        this.interfaces = interfaces == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(interfaces));
        this.sourceFile = sourceFile;
        this.annotations = ImmutableAnnotation.immutableSetOf(annotations);
        this.staticFields = ImmutableField.immutableSetOf(IteratorUtils.filter(fields, FieldUtil.FIELD_IS_STATIC));
        this.instanceFields = ImmutableField.immutableSetOf(IteratorUtils.filter(fields, FieldUtil.FIELD_IS_INSTANCE));
        this.directMethods = ImmutableMethod.immutableSetOf(IteratorUtils.filter(methods, MethodUtil.METHOD_IS_DIRECT));
        this.virtualMethods = ImmutableMethod.immutableSetOf(IteratorUtils.filter(methods, MethodUtil.METHOD_IS_VIRTUAL));
    }

    public ImmutableClassDef(@Nonnull String type, int accessFlags, @Nullable String superclass, @Nullable Collection<String> interfaces, @Nullable String sourceFile, @Nullable Collection<? extends Annotation> annotations, @Nullable Iterable<? extends Field> staticFields, @Nullable Iterable<? extends Field> instanceFields, @Nullable Iterable<? extends Method> directMethods, @Nullable Iterable<? extends Method> virtualMethods) {
        this.type = type;
        this.accessFlags = accessFlags;
        this.superclass = superclass;
        this.interfaces = interfaces == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(interfaces));
        this.sourceFile = sourceFile;
        this.annotations = ImmutableAnnotation.immutableSetOf(annotations);
        this.staticFields = ImmutableField.immutableSetOf(staticFields);
        this.instanceFields = ImmutableField.immutableSetOf(instanceFields);
        this.directMethods = ImmutableMethod.immutableSetOf(directMethods);
        this.virtualMethods = ImmutableMethod.immutableSetOf(virtualMethods);
    }

    public ImmutableClassDef(@Nonnull String type, int accessFlags, @Nullable String superclass, @Nullable List<String> interfaces, @Nullable String sourceFile, @Nullable Set<? extends ImmutableAnnotation> annotations, @Nullable SortedSet<? extends ImmutableField> staticFields, @Nullable SortedSet<? extends ImmutableField> instanceFields, @Nullable SortedSet<? extends ImmutableMethod> directMethods, @Nullable SortedSet<? extends ImmutableMethod> virtualMethods) {
        this.type = type;
        this.accessFlags = accessFlags;
        this.superclass = superclass;
        this.interfaces = ImmutableUtils.nullToEmptyList(interfaces);
        this.sourceFile = sourceFile;
        this.annotations = ImmutableUtils.nullToEmptySet(annotations);
        this.staticFields = ImmutableUtils.nullToEmptySortedSet(staticFields);
        this.instanceFields = ImmutableUtils.nullToEmptySortedSet(instanceFields);
        this.directMethods = ImmutableUtils.nullToEmptySortedSet(directMethods);
        this.virtualMethods = ImmutableUtils.nullToEmptySortedSet(virtualMethods);
    }

    public static ImmutableClassDef of(ClassDef classDef) {
        if (classDef instanceof ImmutableClassDef) {
            return (ImmutableClassDef)classDef;
        }
        return new ImmutableClassDef(classDef.getType(), classDef.getAccessFlags(), classDef.getSuperclass(), classDef.getInterfaces(), classDef.getSourceFile(), classDef.getAnnotations(), classDef.getStaticFields(), classDef.getInstanceFields(), classDef.getDirectMethods(), classDef.getVirtualMethods());
    }

    @Override
    @Nonnull
    public String getType() {
        return this.type;
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    @Nullable
    public String getSuperclass() {
        return this.superclass;
    }

    @Override
    @Nonnull
    public List<String> getInterfaces() {
        return this.interfaces;
    }

    @Override
    @Nullable
    public String getSourceFile() {
        return this.sourceFile;
    }

    @Nonnull
    public Set<? extends ImmutableAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Nonnull
    public Set<? extends ImmutableField> getStaticFields() {
        return this.staticFields;
    }

    @Nonnull
    public Set<? extends ImmutableField> getInstanceFields() {
        return this.instanceFields;
    }

    @Nonnull
    public Set<? extends ImmutableMethod> getDirectMethods() {
        return this.directMethods;
    }

    @Nonnull
    public Set<? extends ImmutableMethod> getVirtualMethods() {
        return this.virtualMethods;
    }

    @Nonnull
    public Iterable<? extends ImmutableField> getFields() {
        return new ChainedIterable<ImmutableField>(this.staticFields, this.instanceFields);
    }

    @Nonnull
    public Iterable<? extends ImmutableMethod> getMethods() {
        return new ChainedIterable<ImmutableMethod>(this.directMethods, this.virtualMethods);
    }

    @Nonnull
    public static Set<ImmutableClassDef> immutableSetOf(@Nullable Iterable<? extends ClassDef> iterable) {
        return CONVERTER.toSet(iterable);
    }
}

