/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.basex.api.client.ClientQuery;
import org.basex.api.client.Session;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.io.in.BufferInput;
import org.basex.io.in.ServerInput;
import org.basex.io.out.ArrayOutput;
import org.basex.io.out.PrintOutput;
import org.basex.io.out.ServerOutput;
import org.basex.server.LoginException;
import org.basex.server.ServerCmd;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Token;

public class ClientSession
extends Session {
    final PrintOutput sout;
    final InputStream sin;
    private final Socket socket = new Socket();

    public ClientSession(Context context, String username, String password) throws IOException {
        this(context, username, password, null);
    }

    public ClientSession(Context context, String username, String password, OutputStream output) throws IOException {
        this(context.soptions.get(StaticOptions.HOST), context.soptions.get(StaticOptions.PORT), username, password, output);
    }

    public ClientSession(String host, int port, String username, String password) throws IOException {
        this(host, port, username, password, null);
    }

    public ClientSession(String host, int port, String username, String password, OutputStream output) throws IOException {
        super(output);
        String nonce;
        Object code;
        this.socket.setTcpNoDelay(true);
        try {
            this.socket.connect(new InetSocketAddress(host, port), 5000);
        }
        catch (IllegalArgumentException ex) {
            throw new BaseXException(ex);
        }
        this.sin = this.socket.getInputStream();
        BufferInput bi = BufferInput.get(this.sin);
        String[] response = Strings.split(bi.readString(), ':');
        if (response.length > 1) {
            code = username + ":" + response[0] + ":" + password;
            nonce = response[1];
        } else {
            code = password;
            nonce = response[0];
        }
        this.sout = PrintOutput.get(this.socket.getOutputStream());
        this.send(username);
        this.send(Strings.md5(Strings.md5((String)code) + nonce));
        this.sout.flush();
        if (!ClientSession.ok(bi)) {
            throw new LoginException(username);
        }
    }

    @Override
    public void create(String name, InputStream input) throws IOException {
        this.send(ServerCmd.CREATE, input, name);
    }

    @Override
    public void add(String path, InputStream input) throws IOException {
        this.send(ServerCmd.ADD, input, path);
    }

    @Override
    public void put(String path, InputStream input) throws IOException {
        this.send(ServerCmd.PUT, input, path);
    }

    @Override
    public void putBinary(String path, InputStream input) throws IOException {
        this.send(ServerCmd.PUTBINARY, input, path);
    }

    @Override
    public ClientQuery query(String query) throws IOException {
        return new ClientQuery(query, this, this.out);
    }

    @Override
    public synchronized void close() throws IOException {
        this.socket.close();
    }

    @Override
    protected void execute(String command, OutputStream output) throws IOException {
        this.send(command);
        this.sout.flush();
        this.receive(output);
    }

    @Override
    protected void execute(Command command, OutputStream output) throws IOException {
        this.execute(command.toString(), output);
    }

    private void send(InputStream input) throws IOException {
        int b;
        ServerOutput so = new ServerOutput(this.sout);
        while ((b = input.read()) != -1) {
            so.write(b);
        }
        this.sout.write(0);
        this.sout.flush();
        this.receive(null);
    }

    private void receive(OutputStream output) throws IOException {
        BufferInput bi = BufferInput.get(this.sin);
        if (output != null) {
            ClientSession.receive(bi, output);
        }
        this.info = bi.readString();
        if (!ClientSession.ok(bi)) {
            throw new BaseXException(this.info, new Object[0]);
        }
    }

    static boolean ok(BufferInput input) throws IOException {
        return input.read() == 0;
    }

    private void send(ServerCmd command, InputStream input, String ... args) throws IOException {
        this.sout.write(command.code);
        for (String arg : args) {
            this.send(arg);
        }
        this.send(input);
    }

    static void receive(BufferInput input, OutputStream output) throws IOException {
        int b;
        ServerInput si = new ServerInput(input);
        while ((b = si.read()) != -1) {
            output.write(b);
        }
    }

    void send(String string) throws IOException {
        this.sout.write(Token.token(string));
        this.sout.write(0);
    }

    String exec(ServerCmd command, String arg, OutputStream output) throws IOException {
        OutputStream o = output == null ? new ArrayOutput() : output;
        this.sout.write(command.code);
        this.send(arg);
        this.sout.flush();
        BufferInput bi = BufferInput.get(this.sin);
        ClientSession.receive(bi, o);
        if (!ClientSession.ok(bi)) {
            throw new BaseXException(bi.readString(), new Object[0]);
        }
        return o.toString();
    }

    public String toString() {
        return Prop.PROJECT + ":/" + String.valueOf(this.socket.getLocalAddress()) + ":" + this.socket.getPort();
    }
}

