/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.text.TextPanel;
import org.basex.util.Performance;

public final class DialogMem
extends BaseXDialog {
    private static Dialog dialog;
    private final TextPanel text;
    private final BaseXButton gc;

    private DialogMem(GUI gui) {
        super(gui, Text.USED_MEM, false);
        this.panel.setLayout(new BorderLayout());
        this.text = new TextPanel(this, DialogMem.info(), false);
        this.text.setFont(this.panel.getFont());
        this.set(this.text, "Center");
        this.gc = new BaseXButton(this, "GC");
        BaseXBack buttons = this.newButtons(this.gc);
        this.set(buttons, "South");
        this.addTimer();
        this.finish();
    }

    public static void show(GUI gui) {
        if (dialog == null) {
            dialog = new DialogMem(gui);
        }
        dialog.setVisible(true);
    }

    @Override
    public void setVisible(boolean v) {
        super.setVisible(v);
        SwingUtilities.invokeLater(this.gc::requestFocusInWindow);
    }

    @Override
    public void action(Object cmp) {
        Performance.gc(3);
        this.text.setText(DialogMem.info());
    }

    private static String info() {
        Runtime rt = Runtime.getRuntime();
        long max = rt.maxMemory();
        long total = rt.totalMemory();
        long used = total - rt.freeMemory();
        return Text.TOTAL_MEM_C + Performance.formatHuman(max) + Text.NL + Text.RESERVED_MEM_C + Performance.formatHuman(total) + Text.NL + Text.MEMUSED_C + Performance.formatHuman(used) + Text.NL + Text.NL + Text.H_USED_MEM;
    }

    private void addTimer() {
        new Timer(true).scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (DialogMem.this.isVisible() && !DialogMem.this.text.selected()) {
                    DialogMem.this.text.setText(DialogMem.info());
                }
            }
        }, 0L, 500L);
    }
}

