/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.project;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIPopupCmd;
import org.basex.gui.layout.BaseXImages;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPopup;
import org.basex.gui.view.project.ProjectCommands;
import org.basex.gui.view.project.ProjectView;
import org.basex.io.IOFile;

final class ProjectList
extends JList<String>
implements ProjectCommands {
    private static FontMetrics fm;
    private final ProjectView view;
    final GUIPopupCmd[] commands;
    private String search = "";

    ProjectList(ProjectView view) {
        this.view = view;
        this.setBorder(BaseXLayout.border(4, 4, 4, 4));
        this.setCellRenderer(new CellRenderer());
        this.addMouseListener(e -> {
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                view.open(this.selectedFile(), this.search);
            }
        });
        this.commands = this.commands(new GUIPopupCmd[0]);
        new BaseXPopup(this, view.gui, (GUICommand[])this.commands);
    }

    void setElements(String[] list, String srch) {
        int ll = list.length;
        ListModel model = this.getModel();
        int ms = model.getSize();
        boolean same = ll == ms;
        for (int l = 0; same && l < ll; ++l) {
            same = list[l].equals(model.getElementAt(l));
        }
        if (!same) {
            this.setListData(list);
            if (ll > 0) {
                this.setSelectedIndex(0);
            }
        }
        this.search = srch;
    }

    @Override
    public IOFile selectedFile() {
        List<IOFile> files = this.selectedFiles();
        return files.size() == 1 ? files.get(0) : null;
    }

    @Override
    public List<IOFile> selectedFiles() {
        if (this.isSelectionEmpty() && this.getModel().getSize() != 0) {
            this.setSelectedIndex(0);
        }
        ArrayList<IOFile> files = new ArrayList<IOFile>();
        for (String value : this.getSelectedValuesList()) {
            files.add(new IOFile(value));
        }
        return files;
    }

    @Override
    public ProjectView view() {
        return this.view;
    }

    @Override
    public String search() {
        return this.search;
    }

    @Override
    public void refresh() {
        this.view.refresh();
    }

    private class CellRenderer
    extends DefaultListCellRenderer {
        private final BaseXLabel label;
        private IOFile file = new IOFile(".");

        CellRenderer() {
            this.label = new BaseXLabel(){

                @Override
                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    BaseXLayout.hints(g);
                    if (fm == null) {
                        fm = g.getFontMetrics(CellRenderer.this.label.getFont());
                    }
                    int y = Math.min(fm.getHeight(), (int)CellRenderer.this.label.getPreferredSize().getHeight()) - 2;
                    int x = (int)CellRenderer.this.label.getPreferredSize().getWidth() + 2;
                    String s = CellRenderer.this.file.name();
                    g.setColor(GUIConstants.TEXT);
                    g.drawString(s, x, y);
                    g.setColor(GUIConstants.gray);
                    g.drawString(" \u00b7 " + BaseXLayout.reversePath(CellRenderer.this.file), x += fm.stringWidth(s), y);
                }
            };
            this.label.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean selected, boolean expanded) {
            this.file = new IOFile(value.toString());
            this.label.setIcon(BaseXImages.file(this.file));
            this.label.setText("");
            this.label.setToolTipText(BaseXLayout.info(this.file, true));
            if (selected) {
                this.label.setBackground(ProjectList.this.getSelectionBackground());
                this.label.setForeground(ProjectList.this.getSelectionForeground());
            } else {
                this.label.setBackground(GUIConstants.BACK);
                this.label.setForeground(GUIConstants.TEXT);
            }
            return this.label;
        }
    }
}

