/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.name;

import java.io.IOException;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.data.MetaData;
import org.basex.index.Index;
import org.basex.index.query.EntryIterator;
import org.basex.index.query.IndexEntries;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.IndexSearch;
import org.basex.index.stats.Stats;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.query.util.index.IndexCosts;
import org.basex.util.Array;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenSet;

public final class Names
extends TokenSet
implements Index {
    private Stats[] stats;
    private final MetaData meta;

    public Names(MetaData meta) {
        this.meta = meta;
        this.stats = new Stats[8];
    }

    public Names(DataInput in, MetaData meta) throws IOException {
        super(in);
        this.meta = meta;
        this.stats = new Stats[this.keys.length];
        for (int i = 1; i < this.size; ++i) {
            this.stats[i] = new Stats(in);
        }
    }

    public void init() {
        for (int i = 1; i < this.size; ++i) {
            this.stats[i] = new Stats();
        }
    }

    public int store(byte[] name) {
        return this.store(name, null);
    }

    public int store(byte[] name, byte[] value) {
        int i = this.put(name);
        Stats s = this.stats[i];
        if (s == null) {
            this.stats[i] = s = new Stats();
        }
        if (value != null) {
            s.add(value, this.meta);
        }
        ++s.count;
        return i;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        for (int i = 1; i < this.size; ++i) {
            Stats s = this.stats[i];
            if (s == null) {
                this.stats[i] = s = new Stats();
            }
            s.write(out);
        }
    }

    public Stats stats(int index) {
        return this.stats[index];
    }

    @Override
    public byte[] info(MainOptions options) {
        int[] tl = new int[this.size];
        tl[0] = 0;
        int len = 0;
        for (int i = 1; i < this.size; ++i) {
            if (len < this.keys[i].length) {
                len = this.keys[i].length;
            }
            if (this.stats[i] == null) continue;
            tl[i] = this.stats[i].count;
        }
        len += 2;
        int[] ordered = Array.createOrder(tl, false);
        TokenBuilder tb = new TokenBuilder();
        tb.add("- Structure: ").add("Hash").add(Text.NL);
        tb.add("- Entries: ").addInt(this.size - 1).add(Text.NL);
        for (int i = 0; i < this.size - 1; ++i) {
            int o = ordered[i];
            if (this.stats[o] == null) continue;
            byte[] key = this.keys[o];
            tb.add("  ").add(key);
            int kl = len - key.length;
            for (int k = 0; k < kl; ++k) {
                tb.add(32);
            }
            tb.add(String.valueOf(this.stats[o]) + Text.NL);
        }
        return tb.finish();
    }

    @Override
    public EntryIterator entries(IndexEntries entries) {
        final int sz = this.size();
        return new EntryIterator(){
            int c;

            @Override
            public byte[] next() {
                return this.c < sz ? this.get(this.c) : null;
            }

            @Override
            public byte[] get(int i) {
                this.c = i + 1;
                return Names.this.keys[this.c];
            }

            @Override
            public int count() {
                return Names.this.stats[this.c].count;
            }

            @Override
            public int size() {
                return sz;
            }
        };
    }

    @Override
    protected void rehash(int newSize) {
        super.rehash(newSize);
        this.stats = Array.copy(this.stats, new Stats[newSize]);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean drop() {
        throw Util.notExpected();
    }

    @Override
    public IndexIterator iter(IndexSearch search) {
        throw Util.notExpected();
    }

    @Override
    public IndexCosts costs(IndexSearch search) {
        throw Util.notExpected();
    }
}

