/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.csv;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.io.parse.csv.CsvW3XmlConverter;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.csv.CsvSerializer;
import org.basex.query.QueryError;
import org.basex.query.util.ft.FTPos;
import org.basex.query.value.item.QNm;
import org.basex.util.Token;
import org.basex.util.list.TokenList;

public final class CsvW3XmlSerializer
extends CsvSerializer {
    private final TokenList headers;
    private TokenList data;

    public CsvW3XmlSerializer(OutputStream os, SerializerOptions sopts) throws IOException {
        super(os, sopts);
        this.headers = this.header ? new TokenList() : null;
    }

    @Override
    protected void startOpen(QNm name) {
        if (this.level == 2) {
            this.data = new TokenList();
        }
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.finishOpen();
        switch (this.level) {
            case 2: {
                if (!this.header || !this.elem.eq(CsvW3XmlConverter.Q_FN_COLUMN)) break;
                this.headers.add(Token.EMPTY);
                break;
            }
            case 3: {
                this.data.add(Token.EMPTY);
            }
        }
        this.finishClose();
    }

    @Override
    protected void text(byte[] value, FTPos ftp) {
        switch (this.level) {
            case 3: {
                if (!this.header || !this.elem.eq(CsvW3XmlConverter.Q_FN_COLUMN)) break;
                this.headers.add(value);
                break;
            }
            case 4: {
                this.data.add(value);
            }
        }
    }

    @Override
    protected void finishClose() throws IOException {
        if (this.level != 2 || !this.elem.eq(CsvW3XmlConverter.Q_FN_ROW)) {
            return;
        }
        if (this.header) {
            this.record(this.headers, false);
            this.header = false;
        }
        this.record(this.data);
    }

    @Override
    protected void attribute(byte[] name, byte[] value, boolean standalone) throws IOException {
        if (this.headers == null || !Token.eq(name, CsvW3XmlConverter.Q_COLUMN.local())) {
            return;
        }
        if (this.data.size() < this.headers.size() && Token.eq(value, (byte[])this.headers.get(this.data.size()))) {
            return;
        }
        throw QueryError.CSV_SERIALIZE_X_X.getIO("Unexpected column", value);
    }
}

