/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryException;
import org.basex.query.QuerySupplier;
import org.basex.query.expr.And;
import org.basex.query.expr.Arr;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpIR;
import org.basex.query.expr.CmpR;
import org.basex.query.expr.CmpSR;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.expr.Or;
import org.basex.query.expr.Pos;
import org.basex.query.expr.SimpleMap;
import org.basex.query.expr.path.Path;
import org.basex.query.func.Function;
import org.basex.query.func.fn.FnDistinctValues;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Itr;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.VarRef;
import org.basex.util.Checks;
import org.basex.util.InputInfo;

public abstract class Cmp
extends Arr {
    private static final long[] COUNT_TRUE = new long[0];
    private static final long[] COUNT_FALSE = new long[0];
    private static final long[] COUNT_EMPTY = new long[0];
    private static final long[] COUNT_EXISTS = new long[0];

    Cmp(InputInfo info, Expr expr1, Expr expr2, SeqType seqType) {
        super(info, seqType, expr1, expr2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final boolean swap() {
        boolean swap;
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        if (Function.COUNT.is(expr1)) return false;
        if (Function.POSITION.is(expr1)) {
            return false;
        }
        if (Function.COUNT.is(expr2)) return true;
        if (Function.POSITION.is(expr2)) {
            return true;
        }
        boolean bl = swap = false;
        if (!swap && expr2 instanceof Value) {
            if (!(expr1 instanceof Value)) return false;
            if (expr1.size() <= expr2.size()) return false;
            return true;
        }
        if (!swap) {
            swap = expr1 instanceof Value;
        }
        if (!swap) {
            if (expr1.size() > 1L && expr1.size() > expr2.size()) {
                return true;
            }
            boolean bl2 = swap = false;
        }
        if (!swap) {
            if (expr2 instanceof ContextValue && expr2.size() == 1L && !(expr1 instanceof ContextValue)) {
                return true;
            }
            boolean bl3 = false;
            swap = bl3;
        }
        if (swap) return swap;
        if (expr1 instanceof Path) {
            Path pth1 = (Path)expr1;
            if (pth1.root == null) return false;
        }
        if (!(expr2 instanceof Path)) return false;
        Path pth2 = (Path)expr2;
        if (pth2.root != null) return false;
        return true;
    }

    public final Expr invert(CompileContext cc) throws QueryException {
        Expr expr = this.invert();
        return expr != null ? expr.optimize(cc) : this;
    }

    public abstract Expr invert();

    public abstract CmpV.OpV opV();

    public abstract CmpG.OpG opG();

    final Expr opt(CompileContext cc) throws QueryException {
        CmpV.OpV op = this.opV();
        Expr expr = this.optPos(op, cc);
        if (expr == this) {
            expr = this.optEqual(op, cc);
        }
        if (expr == this) {
            expr = this.optCount(op, cc);
        }
        if (expr == this) {
            expr = this.optBoolean(op, cc);
        }
        if (expr == this) {
            expr = this.optEmptyString(op, cc);
        }
        if (expr == this) {
            expr = this.optStringLength(op, cc);
        }
        return expr;
    }

    private Expr optEqual(CmpV.OpV op, CompileContext cc) {
        if (!(this instanceof CmpG)) {
            return this;
        }
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        SeqType st1 = expr1.seqType();
        Type type1 = st1.type;
        if (expr1.equals(expr2) && (op != CmpV.OpV.EQ ? st1.one() : st1.oneOrMore()) && (type1.isStringOrUntyped() || type1.instanceOf(AtomType.DECIMAL) || type1 == AtomType.BOOLEAN) && !expr1.has(Flag.NDT) && (!expr1.has(Flag.CTX) || cc.qc.focus.value != null)) {
            return Bln.get(op == CmpV.OpV.EQ || op == CmpV.OpV.GE || op == CmpV.OpV.LE);
        }
        return this;
    }

    private Expr optBoolean(CmpV.OpV op, CompileContext cc) throws QueryException {
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        SeqType st1 = expr1.seqType();
        SeqType st2 = expr2.seqType();
        if (st1.type == AtomType.BOOLEAN && st2.type == AtomType.BOOLEAN) {
            boolean ne;
            boolean eq = op == CmpV.OpV.EQ;
            boolean bl = ne = op == CmpV.OpV.NE;
            if (expr2 instanceof Bln) {
                boolean ok = expr2 == Bln.TRUE;
                boolean success = ne ^ ok;
                if (st1.zeroOrOne() && (success || st1.one())) {
                    Expr ex1 = st1.one() ? expr1 : cc.function(Function.BOOLEAN, this.info, expr1);
                    QuerySupplier<Expr> not = () -> cc.function(Function.NOT, this.info, ex1);
                    return switch (op) {
                        case CmpV.OpV.EQ -> {
                            if (ok) {
                                yield ex1;
                            }
                            yield not.get();
                        }
                        case CmpV.OpV.NE -> {
                            if (ok) {
                                yield not.get();
                            }
                            yield ex1;
                        }
                        case CmpV.OpV.GE -> {
                            if (ok) {
                                yield ex1;
                            }
                            yield Bln.TRUE;
                        }
                        case CmpV.OpV.LE -> {
                            if (ok) {
                                yield Bln.TRUE;
                            }
                            yield not.get();
                        }
                        case CmpV.OpV.GT -> {
                            if (ok) {
                                yield Bln.FALSE;
                            }
                            yield ex1;
                        }
                        default -> ok ? not.get() : Bln.FALSE;
                    };
                }
                if (this instanceof CmpG) {
                    Expr[] args = expr1.args();
                    if ((eq || ne) && expr1 instanceof List && ((Checks<Expr>)expr -> expr.seqType().eq(SeqType.BOOLEAN_O)).all((Expr[])args)) {
                        return success ? new Or(this.info, args).optimize(cc) : cc.function(Function.NOT, this.info, new And(this.info, args).optimize(cc));
                    }
                    if (expr1 instanceof SimpleMap) {
                        Expr[] ops;
                        SimpleMap map = (SimpleMap)expr1;
                        int al = args.length - 1;
                        Expr last = args[al];
                        if (last instanceof Bln) {
                            Bln bln = (Bln)last;
                            if (eq || ne) {
                                return bln.bool(this.info) != success ? Bln.FALSE : cc.function(Function.EXISTS, this.info, map.remove(cc, al));
                            }
                        }
                        if ((ops = last.args()) != null && ops.length > 0 && ops[0] instanceof ContextValue) {
                            if (last instanceof CmpG) {
                                CmpG cmp = (CmpG)last;
                                Expr op2 = ops[1];
                                if (!op2.has(Flag.CTX) && (eq && ok || op2.seqType().one())) {
                                    CmpG.OpG opG = cmp.op;
                                    if (!success) {
                                        opG = opG.invert();
                                    }
                                    return new CmpG(this.info, map.remove(cc, al), op2, opG).optimize(cc);
                                }
                            } else {
                                if (success && last instanceof CmpR) {
                                    CmpR cmp = (CmpR)last;
                                    return CmpR.get(cc, this.info, map.remove(cc, al), cmp.min, cmp.max);
                                }
                                if (success && last instanceof CmpIR) {
                                    CmpIR cmp = (CmpIR)last;
                                    return CmpIR.get(cc, this.info, map.remove(cc, al), cmp.min, cmp.max);
                                }
                                if (success && last instanceof CmpSR) {
                                    CmpSR cmp = (CmpSR)last;
                                    return new CmpSR(map.remove(cc, al), cmp.min, cmp.mni, cmp.max, cmp.mxi, this.info).optimize(cc);
                                }
                            }
                        }
                    }
                }
            }
            if ((eq || ne) && st1.one() && st2.one() && (Function.NOT.is(expr2) && expr1.equals(expr2.arg(0)) || Function.NOT.is(expr1) && expr2.equals(expr1.arg(0)))) {
                return Bln.get(ne);
            }
        }
        return this;
    }

    private Expr optCount(CmpV.OpV op, CompileContext cc) throws QueryException {
        Expr expr1 = this.exprs[0];
        if (!Function.COUNT.is(expr1)) {
            return this;
        }
        Expr arg = expr1.arg(0);
        Expr count = this.exprs[1];
        if (Function.COUNT.is(count)) {
            Expr carg = count.arg(0);
            if (Function.DISTINCT_VALUES.is(carg) && arg.equals(carg.arg(0))) {
                return ((FnDistinctValues)carg).duplicates(op, cc);
            }
            if (Function.DISTINCT_VALUES.is(arg) && arg.arg(0).equals(carg)) {
                return ((FnDistinctValues)arg).duplicates(op.swap(), cc);
            }
        }
        if (Function.DISTINCT_VALUES.is(arg) && count instanceof Itr) {
            Itr itr = (Itr)count;
            long size1 = arg.arg(0).size();
            long size2 = itr.itr();
            if (size1 != -1L && size1 == size2) {
                return ((FnDistinctValues)arg).duplicates(op.swap(), cc);
            }
        }
        ExprList args = new ExprList(3L);
        if (count instanceof ANum) {
            long[] counts;
            ANum num = (ANum)count;
            double cnt = num.dbl();
            if (arg.seqType().zeroOrOne()) {
                if (cnt > 1.0) {
                    return Bln.get(op == CmpV.OpV.LT || op == CmpV.OpV.LE || op == CmpV.OpV.NE);
                }
                if (cnt == 1.0) {
                    return op == CmpV.OpV.NE || op == CmpV.OpV.LT ? cc.function(Function.EMPTY, this.info, arg) : (op == CmpV.OpV.EQ || op == CmpV.OpV.GE ? cc.function(Function.EXISTS, this.info, arg) : Bln.get(op == CmpV.OpV.LE));
                }
            }
            if ((counts = Cmp.countRange(op, cnt)) == COUNT_TRUE) {
                return Bln.TRUE;
            }
            if (counts == COUNT_FALSE) {
                return Bln.FALSE;
            }
            if (counts == COUNT_EMPTY) {
                return cc.function(Function.EMPTY, this.info, arg);
            }
            if (counts == COUNT_EXISTS) {
                return cc.function(Function.EXISTS, this.info, arg);
            }
            if (counts != null) {
                for (long c : counts) {
                    args.add(Itr.get(c));
                }
            }
        } else if (op == CmpV.OpV.EQ || op == CmpV.OpV.GE || op == CmpV.OpV.LE) {
            SeqType st2 = count.seqType();
            if (st2.type.instanceOf(AtomType.INTEGER)) {
                if (count instanceof RangeSeq) {
                    RangeSeq rs = (RangeSeq)count;
                    ((ExprList)((Object)args.add(Itr.get(rs.min())))).add(Itr.get(rs.max()));
                } else if (st2.one() && (count instanceof VarRef || count instanceof ContextValue)) {
                    ((ExprList)((Object)args.add(count))).add(count);
                }
                if (!args.isEmpty()) {
                    if (op == CmpV.OpV.GE) {
                        args.remove(args.size() - 1);
                    } else if (op == CmpV.OpV.LE) {
                        args.set(0, Itr.ONE);
                    }
                }
            }
        }
        if (args.isEmpty()) {
            return this;
        }
        args.insert(0, arg);
        return cc.function(Function._UTIL_COUNT_WITHIN, this.info, (Expr[])args.finish());
    }

    private Expr optStringLength(CmpV.OpV op, CompileContext cc) throws QueryException {
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        if (!Function.STRING_LENGTH.is(expr1) || !(expr2 instanceof ANum)) {
            return this;
        }
        ANum num = (ANum)expr2;
        Expr[] args = expr1.args();
        long[] counts = Cmp.countRange(op, num.dbl());
        if (counts == COUNT_TRUE || counts == COUNT_FALSE) {
            SeqType st1;
            Expr arg1;
            Expr expr = arg1 = args.length > 0 ? args[0] : cc.qc.focus.value;
            if (arg1 != null && ((st1 = arg1.seqType()).zero() || st1.one() && st1.type.isStringOrUntyped())) {
                return Bln.get(counts == COUNT_TRUE);
            }
        }
        if (counts == COUNT_EMPTY || counts == COUNT_EXISTS) {
            Function func = counts == COUNT_EMPTY ? Function.NOT : Function.BOOLEAN;
            return cc.function(func, this.info, cc.function(Function.STRING, this.info, args));
        }
        return this;
    }

    private Expr optEmptyString(CmpV.OpV op, CompileContext cc) throws QueryException {
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        SeqType st1 = expr1.seqType();
        if (st1.one() && st1.type.isStringOrUntyped() && expr2 == Str.EMPTY) {
            if (op == CmpV.OpV.LT) {
                return Bln.FALSE;
            }
            if (op == CmpV.OpV.GE) {
                return Bln.TRUE;
            }
            if (op != CmpV.OpV.GT) {
                Function func = op == CmpV.OpV.NE ? Function.BOOLEAN : Function.NOT;
                return cc.function(func, this.info, cc.function(Function.DATA, this.info, this.exprs[0]));
            }
        }
        return this;
    }

    private Expr optPos(CmpV.OpV op, CompileContext cc) throws QueryException {
        Expr expr;
        if (Function.POSITION.is(this.exprs[0]) && this.exprs[1].seqType().type.isNumberOrUntyped() && (expr = Pos.get(this.exprs[1], op, this.info, cc, null)) != null) {
            return expr;
        }
        return this;
    }

    private static long[] countRange(CmpV.OpV op, double count) {
        if (!Double.isFinite(count)) {
            return null;
        }
        long cnt = (long)count;
        if ((op == CmpV.OpV.GT || op == CmpV.OpV.NE) && count < 0.0 || op == CmpV.OpV.GE && count <= 0.0 || op == CmpV.OpV.NE && count != (double)cnt) {
            return COUNT_TRUE;
        }
        if (op == CmpV.OpV.LT && count <= 0.0 || (op == CmpV.OpV.LE || op == CmpV.OpV.EQ) && count < 0.0 || op == CmpV.OpV.EQ && count != (double)cnt) {
            return COUNT_FALSE;
        }
        if (op == CmpV.OpV.LT && count <= 1.0 || op == CmpV.OpV.LE && count < 1.0 || op == CmpV.OpV.EQ && count == 0.0) {
            return COUNT_EMPTY;
        }
        if (op == CmpV.OpV.GT && count < 1.0 || op == CmpV.OpV.GE && count <= 1.0 || op == CmpV.OpV.NE && count == 0.0) {
            return COUNT_EXISTS;
        }
        if (op == CmpV.OpV.GT) {
            return new long[]{(long)Math.floor(count) + 1L};
        }
        if (op == CmpV.OpV.GE) {
            return new long[]{(long)Math.ceil(count)};
        }
        if (op == CmpV.OpV.LT) {
            return new long[]{0L, (long)Math.ceil(count) - 1L};
        }
        if (op == CmpV.OpV.LE) {
            return new long[]{0L, (long)Math.floor(count)};
        }
        if (op == CmpV.OpV.EQ) {
            return new long[]{cnt, cnt};
        }
        return null;
    }
}

