/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.ft.FTTokens;
import org.basex.query.expr.ft.FTWildcard;
import org.basex.query.util.ft.FTMatches;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.ft.FTBitapSearch;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.hash.TokenObjectMap;
import org.basex.util.list.TokenList;
import org.basex.util.similarity.Levenshtein;

public final class FTTokenizer {
    final FTBitapSearch.TokenComparator cmp;
    private final TokenObjectMap<FTWildcard> wcCache = new TokenObjectMap();
    private final TokenObjectMap<FTTokens> cache = new TokenObjectMap();
    private final FTOpt opt;
    FTMatches matches = new FTMatches();
    boolean first;
    int pos;

    FTTokenizer(FTOpt opt, int errors, InputInfo info) {
        this.opt = opt;
        this.cmp = (in, qu) -> {
            Levenshtein ls = opt.is(FTFlag.FZ) ? new Levenshtein(opt.errors != -1 ? opt.errors : errors) : null;
            FTWildcard ftw = null;
            if (opt.is(FTFlag.WC)) {
                ftw = this.wcCache.get(qu);
                if (ftw == null) {
                    ftw = new FTWildcard(qu);
                    if (!ftw.valid()) {
                        throw QueryError.FTWILDCARD_X.get(info, new Object[]{qu});
                    }
                    this.wcCache.put(qu, ftw);
                }
                if (ftw.simple()) {
                    ftw = null;
                }
            }
            return opt.sw != null && opt.sw.contains(qu) || (opt.is(FTFlag.FZ) ? ls.similar(in, qu) : (ftw != null ? ftw.match(in) : Token.eq(in, qu)));
        };
    }

    FTTokens cache(byte[] input) throws QueryException {
        FTTokens tokens = this.cache.get(input);
        if (tokens == null) {
            tokens = new FTTokens();
            this.cache.put(input, tokens);
            FTLexer lexer = new FTLexer(this.opt).init(input);
            TokenList list = new TokenList(1L);
            while (lexer.hasNext()) {
                list.add(((FTIterator)lexer).nextToken());
            }
            tokens.add(list);
            if (this.opt.th != null) {
                for (byte[] thes : this.opt.th.find(input)) {
                    TokenList tl = new TokenList(1L);
                    ((FTIterator)lexer).init(thes);
                    while (lexer.hasNext()) {
                        tl.add(((FTIterator)lexer).nextToken());
                    }
                    tokens.add(tl);
                }
            }
        }
        return tokens;
    }
}

