/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import org.basex.data.Data;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.db.DbNodePre;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.seq.Seq;
import org.basex.util.list.IntList;

public class DbNodeId
extends StandardFunc {
    @Override
    public final Iter iter(final QueryContext qc) throws QueryException {
        final Iter nodes = this.arg(0).iter(qc);
        if (nodes.size() >= 0L) {
            return this.ids(nodes.value(qc, null)).iter();
        }
        return new Iter(){

            @Override
            public Itr next() throws QueryException {
                Item item = qc.next(nodes);
                return item != null ? Itr.get(DbNodeId.this.id(DbNodeId.this.toDBNode(item, false))) : null;
            }
        };
    }

    @Override
    public final Value value(QueryContext qc) throws QueryException {
        return this.ids(this.arg(0).value(qc));
    }

    final Value ids(Value nodes) throws QueryException {
        IntList ids = new IntList(Seq.initialCapacity(nodes.size()));
        this.addIds(nodes, ids);
        return IntSeq.get(ids.finish());
    }

    protected void addIds(Value nodes, IntList ids) throws QueryException {
        for (Item node : nodes) {
            ids.add(this.id(this.toDBNode(node, false)));
        }
    }

    @Override
    protected final Expr opt(CompileContext cc) throws QueryException {
        Expr nodes = this.arg(0);
        Data data = nodes.data();
        if (data != null && !data.meta.updindex && !(this instanceof DbNodePre)) {
            return cc.function(Function._DB_NODE_PRE, this.info, nodes);
        }
        this.exprType.assign(this.seqType(), nodes.seqType().occ, nodes.size());
        return this;
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr expr = this;
        Expr input = this.arg(0);
        if (mode == CompileContext.Simplify.COUNT && input.ddo()) {
            expr = input;
        }
        return cc.simplify(this, expr, mode);
    }

    protected int id(DBNode node) {
        return node.data().id(node.pre());
    }
}

