/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import java.util.Locale;
import org.basex.data.Data;
import org.basex.data.MetaProp;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.db.DbAccessFn;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.MapBuilder;
import org.basex.util.InputInfo;

public class DbPropertyMap
extends DbAccessFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Data data = this.toData(qc);
        MapBuilder map = new MapBuilder();
        for (MetaProp prop : MetaProp.values()) {
            map.put(prop.name().toLowerCase(Locale.ENGLISH), (Value)DbPropertyMap.item(prop.value(data.meta)));
        }
        return map.map();
    }

    @Override
    protected final Expr opt(CompileContext cc) throws QueryException {
        return cc.dynamic && this.values(true, cc) ? this.value(cc.qc) : this.compileData(cc);
    }

    static Item item(Object value) {
        if (value instanceof Boolean) {
            Boolean bln = (Boolean)value;
            return Bln.get(bln);
        }
        if (value instanceof Integer) {
            Integer itr = (Integer)value;
            return Itr.get(itr.intValue());
        }
        if (value instanceof Long) {
            Long lng = (Long)value;
            return Itr.get(lng);
        }
        return Str.get(value.toString());
    }
}

