/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.file.FileFn;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.StrLazy;

public final class FileReadText
extends FileFn {
    @Override
    public Item item(QueryContext qc) throws QueryException {
        Path path = this.toPath(this.arg(0), qc);
        String encoding = this.toEncodingOrNull(this.arg(1), QueryError.FILE_UNKNOWN_ENCODING_X, qc);
        boolean fallback = this.toBooleanOrFalse(this.arg(2), qc);
        if (!Files.exists(path, new LinkOption[0])) {
            throw QueryError.FILE_NOT_FOUND_X.get(this.info, path.toAbsolutePath());
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw QueryError.FILE_IS_DIR_X.get(this.info, path.toAbsolutePath());
        }
        return new StrLazy(new IOFile(path), encoding, QueryError.FILE_IO_ERROR_X, !fallback);
    }
}

