/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives.db;

import java.io.IOException;
import java.util.ArrayList;
import org.basex.data.Data;
import org.basex.io.IOFile;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.db.DBUpdate;
import org.basex.query.value.node.DBNode;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class Put
extends DBUpdate {
    private final StringList paths = new StringList(1L);
    private final ArrayList<SerializerOptions> options = new ArrayList();
    public final int id;

    public Put(int id, Data data, String path, SerializerOptions sopts, InputInfo info) {
        super(UpdateType.FNPUT, data, info);
        this.id = id;
        this.paths.add(path);
        this.options.add(sopts);
    }

    @Override
    public void prepare() {
    }

    @Override
    public void apply() throws QueryException {
        int pre = this.data.pre(this.id);
        if (pre == -1) {
            return;
        }
        int pl = this.paths.size();
        for (int p = 0; p < pl; ++p) {
            IOFile path = new IOFile((String)this.paths.get(p));
            DBNode node = new DBNode(this.data, pre);
            try (PrintOutput po = new PrintOutput(path);
                 Serializer ser = Serializer.get(po, this.options.get(p));){
                ser.serialize(node);
                continue;
            }
            catch (IOException ex) {
                Util.debug(ex);
                throw QueryError.UPPUTERR_X.get(this.info, path);
            }
        }
    }

    @Override
    public void merge(Update update) {
        for (String path : ((Put)update).paths) {
            this.paths.add(path);
        }
    }

    @Override
    public int size() {
        return this.paths.size();
    }

    public String toString() {
        return Util.className(this) + "[" + this.id + ", " + (String)this.paths.get(0) + "]";
    }
}

