/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.format;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Calc;
import org.basex.query.func.fn.FnRound;
import org.basex.query.util.format.DecFormatOptions;
import org.basex.query.util.format.FormatUtil;
import org.basex.query.util.format.IcuFormatter;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Itr;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.map.XQMap;
import org.basex.util.InputInfo;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntSet;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;
import org.basex.util.options.Option;
import org.basex.util.options.StringOption;

public final class DecFormatter
extends FormatUtil {
    private final DecFormatOptions options;
    private final byte[] digits;
    private final byte[] actives;
    private final int zero;
    private byte[] inf = Token.POSITIVE_INFINITY;
    private byte[] nan = Token.NAN;
    private int pattern = 59;
    private int decimal = 46;
    private int exponent = 101;
    private int grouping = 44;
    private int digit = 35;
    private int[] minus = new int[]{45};
    private int percent = 37;
    private int permille = 8240;
    private int[] decimalRendition = new int[]{this.decimal};
    private int[] exponentRendition = new int[]{this.exponent};
    private int[] groupingRendition = new int[]{this.grouping};
    private int[] percentRendition = new int[]{this.percent};
    private int[] permilleRendition = new int[]{this.permille};

    public DecFormatter() throws QueryException {
        this(new DecFormatOptions(), null);
    }

    public DecFormatter(DecFormatOptions options, InputInfo info) throws QueryException {
        this.options = options;
        int z = 48;
        for (Option<?> option : options) {
            if (!options.contains(option)) continue;
            String k = option.name();
            byte[] v = Token.token(options.get((StringOption)option));
            if (option == DecFormatOptions.INFINITY) {
                this.inf = v;
                continue;
            }
            if (option == DecFormatOptions.NAN) {
                this.nan = v;
                continue;
            }
            if (option == DecFormatOptions.DECIMAL_SEPARATOR) {
                this.decimalRendition = DecFormatter.renditionValue(k, v, info);
                this.decimal = Token.cp(v, 0);
                continue;
            }
            if (option == DecFormatOptions.GROUPING_SEPARATOR) {
                this.groupingRendition = DecFormatter.renditionValue(k, v, info);
                this.grouping = Token.cp(v, 0);
                continue;
            }
            if (option == DecFormatOptions.EXPONENT_SEPARATOR) {
                this.exponentRendition = DecFormatter.renditionValue(k, v, info);
                this.exponent = Token.cp(v, 0);
                continue;
            }
            if (option == DecFormatOptions.PERCENT) {
                this.percentRendition = DecFormatter.renditionValue(k, v, info);
                this.percent = Token.cp(v, 0);
                continue;
            }
            if (option == DecFormatOptions.PER_MILLE) {
                this.permilleRendition = DecFormatter.renditionValue(k, v, info);
                this.permille = Token.cp(v, 0);
                continue;
            }
            if (option == DecFormatOptions.MINUS_SIGN) {
                this.minus = Token.cps(v);
                continue;
            }
            if (v.length != 0 && Token.cl(v, 0) == v.length) {
                int cp = Token.cp(v, 0);
                if (option == DecFormatOptions.PATTERN_SEPARATOR) {
                    this.pattern = cp;
                    continue;
                }
                if (option == DecFormatOptions.DIGIT) {
                    this.digit = cp;
                    continue;
                }
                if (option != DecFormatOptions.ZERO_DIGIT) continue;
                z = this.zeroes(cp);
                if (z == -1) {
                    throw QueryError.INVDECFORM_X_X.get(info, k, v);
                }
                if (z == cp) continue;
                throw QueryError.INVDECZERO_X.get(info, Character.valueOf((char)cp));
            }
            if (option == DecFormatOptions.FORMAT_NAME) continue;
            throw QueryError.INVDECSINGLE_X_X.get(info, k, v);
        }
        this.zero = z;
        IntSet is = new IntSet();
        for (int i = 0; i < 10; ++i) {
            is.add(this.zero + i);
        }
        int[] ss = new int[]{this.decimal, this.grouping, this.exponent, this.percent, this.permille, this.digit, this.pattern};
        for (Object s : (String)ss) {
            if (is.add((int)s)) continue;
            throw QueryError.DUPLDECFORM_X.get(info, Character.valueOf((char)s));
        }
        TokenBuilder tb = new TokenBuilder();
        for (int i = 0; i < 10; ++i) {
            tb.add(this.zero + i);
        }
        this.digits = tb.toArray();
        this.actives = tb.add(this.decimal).add(this.exponent).add(this.grouping).add(this.digit).finish();
    }

    private static int[] renditionValue(String name, byte[] value, InputInfo info) throws QueryException {
        if (value.length != 0) {
            int[] cps = Token.cps(value);
            if (cps.length == 1) {
                return cps;
            }
            if (cps[1] == 58) {
                return Arrays.copyOfRange(cps, 2, cps.length);
            }
        }
        throw QueryError.INVDECFORM_X_X.get(info, name, value);
    }

    public static DecFormatter forLanguage(byte[] languageTag, InputInfo info) throws QueryException {
        String l = Token.string(languageTag);
        DecFormatOptions dfo = Prop.ICU ? IcuFormatter.decFormat(l) : DecFormatter.decFormatSymbols(l);
        return dfo != null ? new DecFormatter(dfo, info) : null;
    }

    private static DecFormatOptions decFormatSymbols(String languageTag) {
        for (Locale locale : DecimalFormatSymbols.getAvailableLocales()) {
            if (!locale.toLanguageTag().equals(languageTag)) continue;
            DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance(locale);
            DecFormatOptions dfo = new DecFormatOptions();
            dfo.put(DecFormatOptions.DECIMAL_SEPARATOR, String.valueOf(dfs.getDecimalSeparator()));
            dfo.put(DecFormatOptions.DIGIT, String.valueOf(dfs.getDigit()));
            dfo.put(DecFormatOptions.GROUPING_SEPARATOR, String.valueOf(dfs.getGroupingSeparator()));
            dfo.put(DecFormatOptions.EXPONENT_SEPARATOR, dfs.getExponentSeparator());
            dfo.put(DecFormatOptions.INFINITY, dfs.getInfinity());
            dfo.put(DecFormatOptions.MINUS_SIGN, String.valueOf(dfs.getMinusSign()));
            dfo.put(DecFormatOptions.NAN, dfs.getNaN());
            dfo.put(DecFormatOptions.PATTERN_SEPARATOR, String.valueOf(dfs.getPatternSeparator()));
            dfo.put(DecFormatOptions.PERCENT, String.valueOf(dfs.getPercent()));
            dfo.put(DecFormatOptions.PER_MILLE, String.valueOf(dfs.getPerMill()));
            dfo.put(DecFormatOptions.ZERO_DIGIT, String.valueOf(dfs.getZeroDigit()));
            return dfo;
        }
        return null;
    }

    public DecFormatOptions options() {
        return this.options;
    }

    public XQMap toMap() throws QueryException {
        Function<int[], byte[]> cpToken = rendition -> {
            TokenBuilder tb = new TokenBuilder(((int[])rendition).length);
            for (int r : rendition) {
                tb.add(Token.cpToken(r));
            }
            return tb.finish();
        };
        BiFunction<Integer, int[], byte[]> value = (marker, rendition) -> {
            byte[] m = Token.cpToken(marker);
            if (((int[])rendition).length == 1 && marker == rendition[0]) {
                return m;
            }
            return new TokenBuilder(((int[])rendition).length + 2).add(m).add(58).add((byte[])cpToken.apply((int[])rendition)).finish();
        };
        MapBuilder map = new MapBuilder();
        map.put(DecFormatOptions.DECIMAL_SEPARATOR.name(), value.apply(this.decimal, this.decimalRendition));
        map.put(DecFormatOptions.EXPONENT_SEPARATOR.name(), value.apply(this.exponent, this.exponentRendition));
        map.put(DecFormatOptions.GROUPING_SEPARATOR.name(), value.apply(this.grouping, this.groupingRendition));
        map.put(DecFormatOptions.PERCENT.name(), value.apply(this.percent, this.percentRendition));
        map.put(DecFormatOptions.PER_MILLE.name(), value.apply(this.permille, this.permilleRendition));
        map.put(DecFormatOptions.ZERO_DIGIT.name(), Token.cpToken(this.zero));
        map.put(DecFormatOptions.DIGIT.name(), Token.cpToken(this.digit));
        map.put(DecFormatOptions.PATTERN_SEPARATOR.name(), Token.cpToken(this.pattern));
        map.put(DecFormatOptions.INFINITY.name(), this.inf);
        map.put(DecFormatOptions.NAN.name(), this.nan);
        map.put(DecFormatOptions.MINUS_SIGN.name(), cpToken.apply(this.minus));
        return map.map();
    }

    public byte[] format(ANum number, byte[] picture, InputInfo info) throws QueryException {
        byte[][] patterns;
        TokenList tl = new TokenList();
        byte[] pic = picture;
        int i = Token.indexOf(pic, this.pattern);
        if (i != -1) {
            tl.add(Token.substring(pic, 0, i));
            pic = Token.substring(pic, i + Token.cl(pic, i));
            if (Token.contains(pic, this.pattern)) {
                throw QueryError.PICNUM_X.get(info, new Object[]{picture});
            }
        }
        if (!this.checkSyntax(patterns = (byte[][])((TokenList)tl.add(pic)).finish())) {
            throw QueryError.PICNUM_X.get(info, new Object[]{picture});
        }
        Picture[] pics = this.analyze(patterns);
        return this.format(number, pics, info);
    }

    private boolean checkSyntax(byte[][] patterns) {
        for (byte[] pt : patterns) {
            int cl;
            boolean frac = false;
            boolean act = false;
            boolean expAct = false;
            boolean exp = false;
            boolean digMant = false;
            boolean optInt = false;
            boolean optFrac = false;
            boolean per = false;
            int last = 0;
            int pl = pt.length;
            for (int i = 0; i < pl; i += cl) {
                int ch = DecFormatter.ch(pt, i);
                cl = Token.cl(pt, i);
                boolean containsDigit = Token.contains(this.digits, ch);
                boolean active = Token.contains(this.actives, ch);
                boolean expon = false;
                if (ch == this.decimal) {
                    if (frac) {
                        return false;
                    }
                    frac = true;
                } else if (ch == this.grouping) {
                    if (i == 0 && frac || last == this.decimal || (i + cl < pl ? DecFormatter.ch(pt, i + cl) == this.decimal : !frac)) {
                        return false;
                    }
                    if (last == this.grouping) {
                        return false;
                    }
                } else if (ch == this.exponent) {
                    if (act && this.containsActive(pt, i + cl)) {
                        if (exp) {
                            return false;
                        }
                        expon = true;
                    } else {
                        active = false;
                    }
                } else if (ch == this.percent || ch == this.permille) {
                    if (per) {
                        return false;
                    }
                    per = true;
                } else if (ch == this.digit) {
                    if (frac) {
                        optFrac = true;
                    } else {
                        if (digMant) {
                            return false;
                        }
                        optInt = true;
                    }
                } else if (containsDigit && !exp) {
                    if (optFrac) {
                        return false;
                    }
                    digMant = true;
                }
                if (active) {
                    if (exp) {
                        if (!containsDigit) {
                            return false;
                        }
                        expAct = true;
                    }
                    act = true;
                } else if (act && this.containsActive(pt, i + cl)) {
                    return false;
                }
                last = ch;
                if (!expon) continue;
                exp = true;
            }
            if (!(optInt || optFrac || digMant)) {
                return false;
            }
            if (!exp || !per && expAct) continue;
            return false;
        }
        return true;
    }

    private Picture[] analyze(byte[][] patterns) {
        int picL = patterns.length;
        Picture[] pics = new Picture[picL];
        for (int p = 0; p < picL; ++p) {
            int cl;
            byte[] pt = patterns[p];
            Picture pic = new Picture();
            boolean frac = false;
            boolean act = false;
            boolean exp = false;
            int optInt = 0;
            int optFrac = 0;
            int pl = pt.length;
            for (int i = 0; i < pl; i += cl) {
                IntList pix;
                int ch = DecFormatter.ch(pt, i);
                cl = Token.cl(pt, i);
                boolean active = Token.contains(this.actives, ch);
                if (ch == this.decimal) {
                    frac = true;
                    act = false;
                } else if (ch == this.digit) {
                    if (frac) {
                        ++optFrac;
                    } else {
                        ++optInt;
                    }
                } else if (ch == this.exponent) {
                    if (act && this.containsActive(pt, i + cl)) {
                        exp = true;
                    } else {
                        active = false;
                    }
                } else if (ch == this.grouping) {
                    if (frac) {
                        pic.groupFrac.add(pic.minFrac + optFrac);
                    } else {
                        pic.groupInt.add(pic.minInt + optInt);
                    }
                } else if (Token.contains(this.digits, ch)) {
                    if (exp) {
                        ++pic.minExp;
                    } else if (frac) {
                        ++pic.minFrac;
                    } else {
                        ++pic.minInt;
                    }
                }
                if (active) {
                    act = true;
                    continue;
                }
                IntList intList = pix = frac || act ? pic.suffix : pic.prefix;
                if (ch == this.percent) {
                    pic.pc = true;
                    pix.add(this.percentRendition);
                    continue;
                }
                if (ch == this.permille) {
                    pic.pm = true;
                    pix.add(this.permilleRendition);
                    continue;
                }
                pix.add(ch);
            }
            IntList ipgp = pic.groupInt;
            int igl = ipgp.size();
            for (int g = 0; g < igl; ++g) {
                ipgp.set(g, pic.minInt + optInt - ipgp.get(g));
            }
            if (igl >= 1) {
                int i = ipgp.get(igl - 1);
                pic.isRegular = ipgp.get(0) + i >= pic.minInt + optInt;
                for (int g = igl - 2; g >= 0; --g) {
                    pic.isRegular = pic.isRegular & i * (igl - g) == ipgp.get(g);
                }
                if (pic.isRegular) {
                    pic.groupInt.reset();
                    pic.groupInt.add(i);
                }
            }
            pic.scaling = pic.minInt;
            pic.maxFrac = optFrac + pic.minFrac;
            if (pic.minInt == 0 && pic.maxFrac == 0) {
                if (exp) {
                    pic.minFrac = 1;
                    pic.maxFrac = 1;
                } else {
                    pic.minInt = 1;
                }
            }
            if (exp && pic.minInt == 0 && optInt > 0) {
                pic.minInt = 1;
            }
            if (pic.minInt == 0 && pic.minFrac == 0) {
                pic.minFrac = 1;
            }
            pics[p] = pic;
        }
        return pics;
    }

    private boolean containsActive(byte[] pt, int i) {
        int pl = pt.length;
        for (int p = i; p < pl; p += Token.cl(pt, p)) {
            if (!Token.contains(this.actives, DecFormatter.ch(pt, p))) continue;
            return true;
        }
        return false;
    }

    private byte[] format(ANum item, Picture[] pics, InputInfo info) throws QueryException {
        String s;
        double d = item.dbl(info);
        if (Double.isNaN(d)) {
            return this.nan;
        }
        boolean neg = d < 0.0 || d == 0.0 && Double.doubleToLongBits(d) == Long.MIN_VALUE;
        Picture pic = pics[neg && pics.length == 2 ? 1 : 0];
        IntList res = new IntList();
        IntList intgr = new IntList();
        IntList fract = new IntList();
        int exp = 0;
        ANum num = item;
        if (pic.pc) {
            num = (ANum)Calc.MULTIPLY.eval(num, Itr.get(100L), info);
        }
        if (pic.pm) {
            num = (ANum)Calc.MULTIPLY.eval(num, Itr.get(1000L), info);
        }
        if (Double.isInfinite(num.dbl(info))) {
            intgr.add(Token.cps(this.inf));
        } else {
            int i;
            int fl;
            int il;
            int i2;
            if (pic.minExp != 0 && d != 0.0) {
                BigDecimal dec = num.dec(info).abs().stripTrailingZeros();
                int scl = 0;
                if (dec.compareTo(BigDecimal.ONE) >= 0) {
                    scl = dec.setScale(0, RoundingMode.HALF_DOWN).precision();
                } else {
                    while (dec.compareTo(BigDecimal.ONE) < 0) {
                        dec = dec.multiply(BigDecimal.TEN);
                        --scl;
                    }
                    ++scl;
                }
                exp = scl - pic.scaling;
                if (exp != 0) {
                    BigDecimal n = BigDecimal.TEN.pow(Math.abs(exp));
                    num = (ANum)Calc.MULTIPLY.eval(num, Dec.get(exp > 0 ? BigDecimal.ONE.divide(n, MathContext.DECIMAL64) : n), info);
                }
            }
            if (Strings.startsWith(s = ((num = num.round(pic.maxFrac, FnRound.RoundMode.HALF_TO_EVEN).abs()) instanceof Dbl || num instanceof Flt ? Dec.get(BigDecimal.valueOf(num.dbl(info))) : num).toString(), '0')) {
                s = s.substring(1);
            }
            int fracSep = s.indexOf(46);
            int sl = s.length();
            for (i2 = il = fracSep == -1 ? sl : fracSep; i2 < pic.minInt; ++i2) {
                intgr.add(this.zero);
            }
            for (i2 = 0; i2 < il; ++i2) {
                intgr.add(this.zero + s.charAt(i2) - 48);
            }
            if (pic.isRegular && pic.groupInt.get(0) > 0) {
                for (i2 = intgr.size() - 1; i2 > 0; --i2) {
                    if (i2 % pic.groupInt.get(0) != 0) continue;
                    intgr.insert(intgr.size() - i2, this.groupingRendition);
                }
            } else {
                int gil = pic.groupInt.size();
                for (int g = 0; g < gil; ++g) {
                    int pos = intgr.size() - pic.groupInt.get(g);
                    if (pos <= 0) continue;
                    intgr.insert(pos, this.groupingRendition);
                }
            }
            int n = fl = fracSep == -1 ? 0 : sl - il - 1;
            if (fl != 0) {
                for (i = fracSep + 1; i < sl; ++i) {
                    fract.add(this.zero + s.charAt(i) - 48);
                }
            }
            for (i = fl; i < pic.minFrac; ++i) {
                fract.add(this.zero);
            }
            int ul = fract.size();
            for (int p = pic.groupFrac.size() - 1; p >= 0; --p) {
                int pos = pic.groupFrac.get(p);
                if (pos >= ul) continue;
                fract.insert(pos, this.groupingRendition);
            }
        }
        if (neg && pics.length != 2) {
            res.add(this.minus);
        }
        res.add(pic.prefix.toArray()).add(intgr.finish());
        if (!fract.isEmpty()) {
            res.add(this.decimalRendition).add(fract.finish());
        }
        if (pic.minExp != 0) {
            int sl;
            int i;
            res.add(this.exponentRendition);
            if (exp < 0) {
                res.add(this.minus);
            }
            s = Integer.toString(Math.abs(exp));
            for (i = sl = s.length(); i < pic.minExp; ++i) {
                res.add(this.zero);
            }
            for (i = 0; i < sl; ++i) {
                res.add(this.zero + s.charAt(i) - 48);
            }
        }
        res.add(pic.suffix.toArray());
        TokenBuilder tb = new TokenBuilder(res.size());
        for (int r : res.finish()) {
            tb.add(r);
        }
        return tb.finish();
    }

    private static final class Picture {
        private final IntList prefix = new IntList();
        private final IntList suffix = new IntList();
        private final IntList groupInt = new IntList();
        private final IntList groupFrac = new IntList();
        private int scaling;
        private boolean isRegular;
        private int minInt;
        private int minFrac;
        private int maxFrac;
        private int minExp;
        private boolean pc;
        private boolean pm;

        private Picture() {
        }
    }
}

