/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.ft;

public final class FTStringMatch
implements Comparable<FTStringMatch> {
    public final int pos;
    public final int start;
    public int end;
    public boolean exclude;
    public boolean gaps;

    public FTStringMatch(int start, int end, int pos) {
        this.start = start;
        this.end = end;
        this.pos = pos;
    }

    boolean in(FTStringMatch mtc) {
        return this.start >= mtc.start && this.end <= mtc.end;
    }

    @Override
    public int compareTo(FTStringMatch sm) {
        int s = this.start - sm.start;
        return Integer.signum(s == 0 ? this.end - sm.end : s);
    }

    public int hashCode() {
        int h = this.start + 1;
        return (h << 5) - h + this.end;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof FTStringMatch)) return false;
        FTStringMatch sm = (FTStringMatch)obj;
        if (this.start != sm.start) return false;
        if (this.end != sm.end) return false;
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.exclude) {
            sb.append("not(");
        }
        sb.append(this.pos).append(':').append(this.start).append('-').append(this.end);
        if (this.exclude) {
            sb.append(')');
        }
        return sb.toString();
    }
}

