/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.array;

import org.basex.query.QueryContext;
import org.basex.query.value.Value;
import org.basex.query.value.array.BigArray;
import org.basex.query.value.array.TreeArray;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.Type;
import org.basex.util.Array;

public final class SmallArray
extends TreeArray {
    final Value[] members;

    SmallArray(Value[] members, Type type) {
        super(type);
        this.members = members;
        assert (members.length >= 2 && members.length <= 7);
    }

    @Override
    public Value memberAt(long index) {
        return this.members[(int)index];
    }

    @Override
    public long structSize() {
        return this.members.length;
    }

    @Override
    public XQArray put(long pos, Value value) {
        Value[] values = (Value[])this.members.clone();
        values[(int)pos] = value;
        return new SmallArray(values, this.union(value));
    }

    @Override
    public XQArray insertMember(long pos, Value value, QueryContext qc) {
        qc.checkStop();
        ArrayType tp = this.union(value);
        int ml = this.members.length;
        int p = (int)pos;
        Value[] out = new Value[ml + 1];
        Array.copy(this.members, p, out);
        out[p] = value;
        Array.copy(this.members, p, ml - p, out, p + 1);
        return ml < 7 ? new SmallArray(out, tp) : new BigArray(SmallArray.slice(out, 0, 4), SmallArray.slice(out, 4, ml + 1), tp);
    }

    @Override
    public XQArray removeMember(long pos, QueryContext qc) {
        qc.checkStop();
        int ml = this.members.length;
        if (ml == 2) {
            return SmallArray.get(this.members[pos == 0L ? 1 : 0]);
        }
        int p = (int)pos;
        Value[] out = new Value[ml - 1];
        Array.copy(this.members, p, out);
        Array.copy(this.members, p + 1, ml - 1 - p, out, p);
        return new SmallArray(out, this.type);
    }

    @Override
    protected XQArray subArr(long pos, long length, QueryContext qc) {
        qc.checkStop();
        int p = (int)pos;
        int l = (int)length;
        return new SmallArray(SmallArray.slice(this.members, p, p + l), this.type);
    }

    @Override
    public XQArray reverseArray(QueryContext qc) {
        int ml = this.members.length;
        Value[] tmp = new Value[ml];
        for (int m = 0; m < ml; ++m) {
            tmp[m] = this.members[ml - 1 - m];
        }
        return new SmallArray(tmp, this.type);
    }
}

