/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.io.IOException;
import java.util.Arrays;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class Hex
extends Bin {
    public Hex(byte[] value) {
        super(value, AtomType.HEX_BINARY);
    }

    public Hex(byte[] value, InputInfo info) throws QueryException {
        this(Hex.parse(Token.trim(value), info));
    }

    public Hex(Bin bin, InputInfo info) throws QueryException {
        this(bin.binary(info));
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeToken(this.data);
    }

    @Override
    public byte[] string(InputInfo ii) {
        return Token.hex(this.data, true);
    }

    public int hashCode() {
        return Token.hashCode(this.data);
    }

    @Override
    public byte[] parse(Item item, InputInfo info) throws QueryException {
        return Hex.parse(item.string(info), info);
    }

    public static byte[] parse(byte[] value, InputInfo info) throws QueryException {
        byte[] bytes = Hex.parse(value);
        if (bytes != null) {
            return bytes;
        }
        throw AtomType.HEX_BINARY.castError(value, info);
    }

    private static byte[] parse(byte[] data) {
        int dl = data.length;
        if ((dl & 1) != 0) {
            return null;
        }
        byte[] array = new byte[dl >>> 1];
        for (int d = 0; d < dl; d += 2) {
            int n = Token.dec(data[d], data[d + 1]);
            if (n < 0) {
                return null;
            }
            array[d >>> 1] = (byte)n;
        }
        return array;
    }

    @Override
    public void toString(QueryString qs) {
        TokenBuilder tb = new TokenBuilder().add(34);
        if (this.data.length > 128) {
            tb.add(Token.hex(Arrays.copyOf(this.data, 128), true)).add("...");
        } else {
            tb.add(Token.hex(this.data, true));
        }
        qs.token(tb.add(34).finish());
    }
}

