/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq.tree;

import java.util.Iterator;
import java.util.ListIterator;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.iter.BasicIter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.seq.tree.SmallSeq;
import org.basex.query.value.seq.tree.TreeSeqBuilder;
import org.basex.query.value.type.Type;
import org.basex.util.Array;

public abstract class TreeSeq
extends Seq {
    static final int MIN_LEAF = 8;
    static final int MAX_LEAF = 15;
    static final int MIN_DIGIT = 4;
    static final int MAX_DIGIT = 19;
    static final int MAX_SMALL = 7;

    TreeSeq(long size, Type type) {
        super(size, type);
    }

    protected final Value copyInsert(long pos, Value value, QueryContext qc) {
        long i;
        long right = this.size - pos;
        if (value instanceof TreeSeq) {
            TreeSeq other = (TreeSeq)value;
            if (pos == 0L || right == 0L) {
                return pos == 0L ? other.concat(this) : this.concat(other);
            }
        }
        TreeSeqBuilder tsb = new TreeSeqBuilder();
        if (pos < 7L) {
            tsb.add(value, qc);
            i = pos;
            while (--i >= 0L) {
                tsb.prepend(this.itemAt(i));
            }
        } else {
            tsb.add(this.subsequence(0L, pos, qc), qc);
            tsb.add(value, qc);
        }
        if (right < 7L) {
            for (i = this.size - right; i < this.size; ++i) {
                tsb.add(this.itemAt(i));
            }
        } else {
            tsb.add(this.subsequence(pos, right, qc), qc);
        }
        return tsb.value(this.type.union(value.type));
    }

    public abstract ListIterator<Item> iterator(long var1);

    @Override
    public final Iterator<Item> iterator() {
        return this.iterator(0L);
    }

    @Override
    public abstract BasicIter<Item> iter();

    abstract TreeSeq concat(TreeSeq var1);

    @Override
    public final Value shrink(QueryContext qc) throws QueryException {
        return this.rebuild(qc);
    }

    abstract TreeSeq prepend(SmallSeq var1);

    static Item[] slice(Item[] items, int from, int to) {
        Item[] out = new Item[to - from];
        int in0 = Math.max(0, from);
        int in1 = Math.min(to, items.length);
        int out0 = Math.max(-from, 0);
        Array.copy(items, in0, in1 - in0, out, out0);
        return out;
    }

    static Item[] concat(Item[] as, Item[] bs) {
        int l = as.length;
        int r = bs.length;
        int n = l + r;
        Item[] out = new Item[n];
        Array.copy(as, l, out);
        Array.copyFromStart(bs, r, out, l);
        return out;
    }
}

