/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq.tree;

import org.basex.query.QueryContext;
import org.basex.query.iter.BasicIter;
import org.basex.query.util.fingertree.FingerTree;
import org.basex.query.util.fingertree.FingerTreeBuilder;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.seq.SeqBuilder;
import org.basex.query.value.seq.tree.BigSeq;
import org.basex.query.value.seq.tree.LeafNode;
import org.basex.query.value.seq.tree.SmallSeq;
import org.basex.query.value.type.Type;
import org.basex.util.Array;
import org.basex.util.Util;

public final class TreeSeqBuilder
implements SeqBuilder {
    private static final int CAP = 38;
    private static final int NODE_SIZE = 12;
    private final Item[] items = new Item[38];
    private int inLeft;
    private int mid = 19;
    private int inRight;
    private final FingerTreeBuilder<Item> tree = new FingerTreeBuilder();

    public TreeSeqBuilder prepend(Item item) {
        if (this.inLeft < 19) {
            this.items[(this.mid - this.inLeft + 38 - 1) % 38] = item;
            ++this.inLeft;
        } else if (this.tree.isEmpty() && this.inRight < 19) {
            this.mid = (this.mid + 38 - 1) % 38;
            this.items[(this.mid - this.inLeft + 38) % 38] = item;
            ++this.inRight;
        } else {
            this.tree.prepend(new LeafNode(this.items(this.mid - 12, 12)));
            int rest = this.inLeft - 12;
            int p0 = (this.mid - this.inLeft + 38) % 38;
            for (int i = 0; i < rest; ++i) {
                int from = (p0 + i) % 38;
                int to = (from + 12) % 38;
                this.items[to] = this.items[from];
            }
            this.items[(this.mid - rest + 38 - 1) % 38] = item;
            this.inLeft = rest + 1;
        }
        return this;
    }

    @Override
    public TreeSeqBuilder add(Item item) {
        if (this.inRight < 19) {
            this.items[(this.mid + this.inRight) % 38] = item;
            ++this.inRight;
        } else if (this.tree.isEmpty() && this.inLeft < 19) {
            this.mid = (this.mid + 1) % 38;
            this.items[(this.mid + this.inRight + 38 - 1) % 38] = item;
            ++this.inLeft;
        } else {
            this.tree.append(new LeafNode(this.items(this.mid, 12)));
            int rest = this.inRight - 12;
            for (int i = 0; i < rest; ++i) {
                int to = (this.mid + i) % 38;
                int from = (to + 12) % 38;
                this.items[to] = this.items[from];
            }
            this.items[(this.mid + rest) % 38] = item;
            this.inRight = rest + 1;
        }
        return this;
    }

    @Override
    public TreeSeqBuilder add(Value value, QueryContext qc) {
        if (value.size() == 1L) {
            return this.add((Item)value);
        }
        if (!(value instanceof BigSeq)) {
            Item item;
            BasicIter<Item> iter = value.iter();
            while ((item = iter.next()) != null) {
                qc.checkStop();
                this.add(item);
            }
            return this;
        }
        BigSeq big = (BigSeq)value;
        Item[] ls = big.left;
        Item[] rs = big.right;
        FingerTree<Item, Item> midTree = big.middle;
        if (midTree.isEmpty()) {
            for (Item l : ls) {
                qc.checkStop();
                this.add(l);
            }
            for (Item r : rs) {
                qc.checkStop();
                this.add(r);
            }
            return this;
        }
        if (this.tree.isEmpty()) {
            int k = this.inLeft + this.inRight;
            Item[] temp = new Item[k];
            int l = (this.mid - this.inLeft + 38) % 38;
            int m = 38 - l;
            if (k <= m) {
                Array.copyToStart(this.items, l, k, temp);
            } else {
                Array.copyToStart(this.items, l, m, temp);
                Array.copyFromStart(this.items, k - m, temp, m);
            }
            this.inRight = 0;
            this.inLeft = 0;
            this.tree.append(midTree);
            int i = ls.length;
            while (--i >= 0) {
                qc.checkStop();
                this.prepend(ls[i]);
            }
            i = k;
            while (--i >= 0) {
                qc.checkStop();
                this.prepend(temp[i]);
            }
            for (Item r : rs) {
                qc.checkStop();
                this.add(r);
            }
            return this;
        }
        int inMiddle = this.inRight + ls.length;
        int leaves = (inMiddle + 15 - 1) / 15;
        int leafSize = (inMiddle + leaves - 1) / leaves;
        int i = 0;
        for (int l = 0; l < leaves; ++l) {
            int inLeaf = Math.min(leafSize, inMiddle - i);
            Item[] leaf = new Item[inLeaf];
            for (int p = 0; p < inLeaf; ++p) {
                leaf[p] = i < this.inRight ? this.items[(this.mid + i) % 38] : ls[i - this.inRight];
                ++i;
            }
            this.tree.append(new LeafNode(leaf));
        }
        this.tree.append(midTree);
        this.inRight = 0;
        for (Item r : rs) {
            qc.checkStop();
            this.add(r);
        }
        return this;
    }

    @Override
    public Seq value(Type type) {
        int n = this.inLeft + this.inRight;
        int start = (this.mid - this.inLeft + 38) % 38;
        if (n <= 7) {
            return new SmallSeq(this.items(start, n), type);
        }
        int ll = this.tree.isEmpty() ? n / 2 : this.inLeft;
        return new BigSeq(this.items(start, ll), this.tree.freeze(), this.items(start + ll, n - ll), type);
    }

    private Item[] items(int from, int n) {
        Item[] arr = new Item[n];
        int p = (from % 38 + 38) % 38;
        int m = 38 - p;
        if (n <= m) {
            Array.copyToStart(this.items, p, n, arr);
        } else {
            Array.copyToStart(this.items, p, m, arr);
            Array.copyFromStart(this.items, n - m, arr, m);
        }
        return arr;
    }

    public String toString() {
        StringBuilder sb;
        block5: {
            block4: {
                sb = new StringBuilder(Util.className(this)).append('[');
                if (!this.tree.isEmpty()) break block4;
                int n = this.inLeft + this.inRight;
                int first = (this.mid - this.inLeft + 38) % 38;
                if (n <= 0) break block5;
                sb.append(this.items[first]);
                for (int i = 1; i < n; ++i) {
                    sb.append(", ").append(this.items[(first + i) % 38]);
                }
                break block5;
            }
            int first = (this.mid - this.inLeft + 38) % 38;
            sb.append(this.items[first]);
            for (int i = 1; i < this.inLeft; ++i) {
                sb.append(", ").append(this.items[(first + i) % 38]);
            }
            for (Item item : this.tree) {
                sb.append(", ").append(item);
            }
            for (int i = 0; i < this.inRight; ++i) {
                sb.append(", ").append(this.items[(this.mid + i) % 38]);
            }
        }
        return sb.append(']').toString();
    }
}

