/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.path.KindTest;
import org.basex.query.expr.path.Test;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.ChoiceItemType;
import org.basex.query.value.type.EnumType;
import org.basex.query.value.type.FType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.ListType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.RecordField;
import org.basex.query.value.type.RecordType;
import org.basex.query.value.type.Type;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjectMap;

public final class SeqType {
    public static final SeqType EMPTY_SEQUENCE_Z = AtomType.ITEM.seqType(Occ.ZERO);
    public static final SeqType ITEM_O = AtomType.ITEM.seqType();
    public static final SeqType ITEM_ZO = AtomType.ITEM.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType ITEM_ZM = AtomType.ITEM.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType ITEM_OM = AtomType.ITEM.seqType(Occ.ONE_OR_MORE);
    public static final SeqType ANY_ATOMIC_TYPE_O = AtomType.ANY_ATOMIC_TYPE.seqType();
    public static final SeqType ANY_ATOMIC_TYPE_ZO = AtomType.ANY_ATOMIC_TYPE.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType ANY_ATOMIC_TYPE_ZM = AtomType.ANY_ATOMIC_TYPE.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType NUMERIC_O = AtomType.NUMERIC.seqType();
    public static final SeqType NUMERIC_ZO = AtomType.NUMERIC.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType NUMERIC_ZM = AtomType.NUMERIC.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType DOUBLE_O = AtomType.DOUBLE.seqType();
    public static final SeqType DOUBLE_ZO = AtomType.DOUBLE.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType DOUBLE_ZM = AtomType.DOUBLE.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType FLOAT_O = AtomType.FLOAT.seqType();
    public static final SeqType DECIMAL_O = AtomType.DECIMAL.seqType();
    public static final SeqType DECIMAL_ZO = AtomType.DECIMAL.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType INTEGER_O = AtomType.INTEGER.seqType();
    public static final SeqType INTEGER_ZO = AtomType.INTEGER.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType INTEGER_ZM = AtomType.INTEGER.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType POSITIVE_INTEGER_O = AtomType.POSITIVE_INTEGER.seqType();
    public static final SeqType BYTE_ZM = AtomType.BYTE.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType STRING_O = AtomType.STRING.seqType();
    public static final SeqType STRING_ZO = AtomType.STRING.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType STRING_ZM = AtomType.STRING.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType STRING_OM = AtomType.STRING.seqType(Occ.ONE_OR_MORE);
    public static final SeqType NCNAME_ZO = AtomType.NCNAME.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType LANGUAGE_O = AtomType.LANGUAGE.seqType();
    public static final SeqType UNTYPED_ATOMIC_O = AtomType.UNTYPED_ATOMIC.seqType();
    public static final SeqType UNTYPED_ATOMIC_ZO = AtomType.UNTYPED_ATOMIC.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType ANY_URI_O = AtomType.ANY_URI.seqType();
    public static final SeqType ANY_URI_ZO = AtomType.ANY_URI.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType ANY_URI_ZM = AtomType.ANY_URI.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType QNAME_O = AtomType.QNAME.seqType();
    public static final SeqType QNAME_ZO = AtomType.QNAME.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType BOOLEAN_O = AtomType.BOOLEAN.seqType();
    public static final SeqType BOOLEAN_ZO = AtomType.BOOLEAN.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType DATE_O = AtomType.DATE.seqType();
    public static final SeqType DATE_ZO = AtomType.DATE.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType DAY_TIME_DURATION_O = AtomType.DAY_TIME_DURATION.seqType();
    public static final SeqType DAY_TIME_DURATION_ZO = AtomType.DAY_TIME_DURATION.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType DATE_TIME_O = AtomType.DATE_TIME.seqType();
    public static final SeqType DATE_TIME_ZO = AtomType.DATE_TIME.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType TIME_O = AtomType.TIME.seqType();
    public static final SeqType TIME_ZO = AtomType.TIME.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType DURATION_ZO = AtomType.DURATION.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType BINARY_O = AtomType.BINARY.seqType();
    public static final SeqType HEX_BINARY_O = AtomType.HEX_BINARY.seqType();
    public static final SeqType BASE64_BINARY_O = AtomType.BASE64_BINARY.seqType();
    public static final SeqType BASE64_BINARY_ZO = AtomType.BASE64_BINARY.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType BASE64_BINARY_ZM = AtomType.BASE64_BINARY.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType NODE_O = NodeType.NODE.seqType();
    public static final SeqType NODE_ZO = NodeType.NODE.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType NODE_ZM = NodeType.NODE.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType NODE_OM = NodeType.NODE.seqType(Occ.ONE_OR_MORE);
    public static final SeqType ATTRIBUTE_O = NodeType.ATTRIBUTE.seqType();
    public static final SeqType ATTRIBUTE_ZM = NodeType.ATTRIBUTE.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType COMMENT_O = NodeType.COMMENT.seqType();
    public static final SeqType DOCUMENT_NODE_O = NodeType.DOCUMENT_NODE.seqType();
    public static final SeqType DOCUMENT_NODE_ZO = NodeType.DOCUMENT_NODE.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType DOCUMENT_NODE_ZM = NodeType.DOCUMENT_NODE.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType ELEMENT_O = NodeType.ELEMENT.seqType();
    public static final SeqType ELEMENT_ZO = NodeType.ELEMENT.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType ELEMENT_ZM = NodeType.ELEMENT.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType NAMESPACE_NODE_O = NodeType.NAMESPACE_NODE.seqType();
    public static final SeqType PROCESSING_INSTRUCTION_O = NodeType.PROCESSING_INSTRUCTION.seqType();
    public static final SeqType TEXT_ZO = NodeType.TEXT.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType TEXT_ZM = NodeType.TEXT.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType NMTOKENS_O = ListType.NMTOKENS.seqType();
    public static final SeqType GREGORIAN_ZO = new ChoiceItemType(Arrays.asList(AtomType.DATE_TIME.seqType(), AtomType.DATE.seqType(), AtomType.TIME.seqType(), AtomType.G_YEAR.seqType(), AtomType.G_YEAR_MONTH.seqType(), AtomType.G_MONTH.seqType(), AtomType.G_MONTH_DAY.seqType(), AtomType.G_DAY.seqType())).seqType(Occ.ZERO_OR_ONE);
    public static final FuncType FUNCTION = new FuncType(null, (SeqType[])null);
    public static final SeqType FUNCTION_O = FUNCTION.seqType();
    public static final SeqType FUNCTION_ZO = FUNCTION.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType FUNCTION_ZM = FUNCTION.seqType(Occ.ZERO_OR_MORE);
    public static final SeqType PREDICATE_O = FuncType.get(BOOLEAN_ZO, ITEM_O, INTEGER_O).seqType();
    public static final SeqType PREDICATE_ZM = FuncType.get(BOOLEAN_ZO, ITEM_ZM, INTEGER_O).seqType();
    public static final SeqType BIPREDICATE_O = FuncType.get(BOOLEAN_ZO, ITEM_O, ITEM_O).seqType();
    public static final SeqType ACTION_O = FuncType.get(ITEM_ZM, ITEM_O, INTEGER_O).seqType();
    public static final FuncType JAVA = new FuncType(null, new SeqType[0]);
    public static final MapType MAP = ITEM_ZM.mapType(AtomType.ANY_ATOMIC_TYPE);
    public static final SeqType MAP_O = MAP.seqType();
    public static final SeqType MAP_ZO = MAP.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType MAP_ZM = MAP.seqType(Occ.ZERO_OR_MORE);
    public static final ArrayType ARRAY = ITEM_ZM.arrayType();
    public static final SeqType ARRAY_O = ARRAY.seqType();
    public static final SeqType ARRAY_ZO = ARRAY.seqType(Occ.ZERO_OR_ONE);
    public static final SeqType ARRAY_ZM = ARRAY.seqType(Occ.ZERO_OR_MORE);
    public static final RecordType RECORD = new RecordType(true, new TokenObjectMap<RecordField>(0L));
    public static final RecordType PAIR;
    public static final RecordType MEMBER;
    public static final SeqType RECORD_O;
    public static final SeqType PAIR_O;
    public static final SeqType PAIR_ZM;
    public static final SeqType MEMBER_ZM;
    public final Type type;
    public final Occ occ;
    private final Test test;
    private ArrayType arrayType;
    private Map<Type, MapType> mapTypes;

    SeqType(Type type, Occ occ) {
        this(type, occ, null);
    }

    private SeqType(Type type, Occ occ, Test test) {
        this.type = type;
        this.occ = occ;
        this.test = test;
    }

    public static SeqType get(Type type, Occ occ) {
        return occ == Occ.ZERO ? EMPTY_SEQUENCE_Z : type.seqType(occ);
    }

    public static SeqType get(Type type, Occ occ, Test test) {
        return occ == Occ.ZERO || test == null || test instanceof KindTest ? SeqType.get(type, occ) : new SeqType(type, occ, test);
    }

    public ArrayType arrayType() {
        if (this.arrayType == null) {
            this.arrayType = new ArrayType(this);
        }
        return this.arrayType;
    }

    public MapType mapType(Type keyType) {
        if (this.mapTypes == null) {
            this.mapTypes = new ConcurrentHashMap<Type, MapType>();
        }
        return this.mapTypes.computeIfAbsent(keyType, k -> new MapType((Type)k, this));
    }

    public SeqType with(Occ oc) {
        return oc == this.occ ? this : SeqType.get(this.type, oc, this.test);
    }

    public SeqType union(Occ oc) {
        return oc == this.occ ? this : SeqType.get(this.type, this.occ.union(oc), this.test);
    }

    public boolean instance(Value value) {
        return this.instance(value, false);
    }

    private boolean instance(Value value, boolean coerce) {
        long size = value.size();
        if (!this.occ.check(size)) {
            return false;
        }
        if (size == 0L) {
            return true;
        }
        if (!(coerce && this.type instanceof FType || this.type instanceof ChoiceItemType)) {
            SeqType st = value.seqType();
            if (st.type.instanceOf(this.type) && st.kindInstanceOf(this)) {
                return true;
            }
        }
        if (size == 1L) {
            return this.instance((Item)value, coerce);
        }
        for (Item item : value) {
            if (this.instance(item, coerce)) continue;
            return false;
        }
        return true;
    }

    public boolean instance(Item item, boolean coerce) {
        Type type = this.type;
        if (type instanceof ChoiceItemType) {
            ChoiceItemType cit = (ChoiceItemType)type;
            for (SeqType tp : cit.types) {
                if (!tp.instance(item, coerce)) continue;
                return true;
            }
            return false;
        }
        return item.instanceOf(this.type, coerce) && (this.test == null || this.test.matches(item));
    }

    public Value cast(Value value, boolean error, QueryContext qc, InputInfo info) throws QueryException {
        long size = value.size();
        if (!this.occ.check(size)) {
            if (error) {
                throw QueryError.typeError((Expr)value, this, info);
            }
            return null;
        }
        if (size == 0L) {
            return Empty.VALUE;
        }
        if (size == 1L) {
            return this.cast((Item)value, error, qc, info);
        }
        ValueBuilder vb = new ValueBuilder(qc);
        for (Item item : value) {
            qc.checkStop();
            vb.add(this.cast(item, error, qc, info));
        }
        return vb.value(this.type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value cast(Item item, boolean error, QueryContext qc, InputInfo info) throws QueryException {
        if (item.type.eq(this.type)) {
            return item;
        }
        if (!error && info != null) {
            info.internal(true);
        }
        try {
            Value value = this.type.cast(item, qc, info);
            return value;
        }
        catch (QueryException ex) {
            if (error) {
                throw ex;
            }
            Value value = null;
            return value;
        }
        finally {
            if (!error && info != null) {
                info.internal(false);
            }
        }
    }

    public Value coerce(Value value, QNm name, QueryContext qc, CompileContext cc, InputInfo info) throws QueryException {
        SeqType[] at;
        Type type = this.type;
        if (type instanceof FuncType) {
            FuncType ft = (FuncType)type;
            v0 = ft.argTypes;
        } else {
            v0 = at = null;
        }
        if ((at == null || ((Checks<SeqType>)st -> st.eq(ITEM_ZM)).all((SeqType[])at)) && this.instance(value, true)) {
            return value;
        }
        ValueBuilder vb = new ValueBuilder(qc, value.size());
        for (Item item : value) {
            qc.checkStop();
            Value val = this.coerce(item, name, qc, cc, info);
            if (val == null) {
                throw QueryError.typeError(item, this.with(Occ.EXACTLY_ONE), name, info);
            }
            vb.add(val);
        }
        Value val = vb.value(this.type);
        if (!this.occ.check(val.size())) {
            throw QueryError.typeError(value, this, name, info);
        }
        return val;
    }

    private Value coerce(Item item, QNm name, QueryContext qc, CompileContext cc, InputInfo info) throws QueryException {
        Type type = this.type;
        if (type instanceof ChoiceItemType) {
            ChoiceItemType cit = (ChoiceItemType)type;
            for (SeqType st : cit.types) {
                try {
                    Value value = st.coerce(item, name, qc, cc, info);
                    if (value == null) continue;
                    return value;
                }
                catch (QueryException ex) {
                    Util.debug(ex);
                }
            }
            return null;
        }
        if (this.type instanceof AtomType || this.type instanceof EnumType) {
            Value value = item.atomValue(qc, info);
            if (value.size() == 1L) {
                return this.coerceAtom((Item)value, qc, info);
            }
            ValueBuilder vb = new ValueBuilder(qc, value.size());
            for (Item it : value) {
                Item cast = this.coerceAtom(it, qc, info);
                if (cast == null) {
                    return null;
                }
                vb.add(cast);
            }
            return vb.value();
        }
        if (item instanceof FItem) {
            Type type2;
            FItem fitem = (FItem)item;
            if (item instanceof XQArray) {
                XQArray array = (XQArray)item;
                Type type3 = this.type;
                if (type3 instanceof ArrayType) {
                    ArrayType at = (ArrayType)type3;
                    return array.coerceTo(at, qc, cc, info);
                }
            } else if (item instanceof XQMap) {
                XQMap map = (XQMap)item;
                Type type4 = this.type;
                if (type4 instanceof RecordType) {
                    RecordType rt = (RecordType)type4;
                    return map.coerceTo(rt, qc, cc, info);
                }
                type4 = this.type;
                if (type4 instanceof MapType) {
                    MapType mt = (MapType)type4;
                    return map.coerceTo(mt, qc, cc, info);
                }
            }
            if ((type2 = this.type) instanceof FuncType) {
                FuncType ft = (FuncType)type2;
                return fitem.coerceTo(this.type == FUNCTION ? item.funcType() : ft, qc, cc, info);
            }
        }
        return this.instance(item, false) ? item : null;
    }

    private Item coerceAtom(Item item, QueryContext qc, InputInfo info) throws QueryException {
        Type at = item.type;
        if (at.instanceOf(this.type)) {
            return item;
        }
        Item relabel = null;
        if (at == AtomType.UNTYPED_ATOMIC) {
            if (this.type.nsSensitive()) {
                throw QueryError.NSSENS_X_X.get(info, at, this.type);
            }
        } else if (!(this.type == AtomType.DECIMAL && (at == AtomType.DOUBLE || at == AtomType.FLOAT) || this.type == AtomType.DOUBLE && (at == AtomType.FLOAT || at.instanceOf(AtomType.DECIMAL)) || this.type == AtomType.FLOAT && (at == AtomType.DOUBLE || at.instanceOf(AtomType.DECIMAL)) || this.type == AtomType.STRING && at == AtomType.ANY_URI || this.type == AtomType.ANY_URI && at.instanceOf(AtomType.STRING) || this.type == AtomType.HEX_BINARY && at == AtomType.BASE64_BINARY || this.type == AtomType.BASE64_BINARY && at == AtomType.HEX_BINARY)) {
            if (!this.type.union(at).oneOf(AtomType.ANY_ATOMIC_TYPE, AtomType.NUMERIC)) {
                relabel = item;
            } else {
                return null;
            }
        }
        Item cast = (Item)this.cast(item, true, qc, info);
        return relabel == null || cast.equal(relabel, null, info) ? cast : null;
    }

    public boolean promotable(SeqType st) {
        if (this.intersect(st) != null) {
            return true;
        }
        if (this.occ.intersect(st.occ) == null) {
            return false;
        }
        Type tp = st.type;
        if (tp instanceof AtomType || tp instanceof ChoiceItemType) {
            if (this.type.isUntyped()) {
                return !tp.nsSensitive();
            }
            return tp == AtomType.DOUBLE && (this.type.intersect(AtomType.FLOAT) != null || this.type.intersect(AtomType.DECIMAL) != null) || tp == AtomType.FLOAT && this.type.intersect(AtomType.DECIMAL) != null || tp == AtomType.STRING && this.type.intersect(AtomType.ANY_URI) != null;
        }
        return st.type instanceof FType && this.type instanceof FType;
    }

    public SeqType union(SeqType st) {
        if (this == st) {
            return this;
        }
        Type tp = st.zero() ? this.type : (this.zero() ? st.type : this.type.union(st.type));
        Occ oc = this.occ.union(st.occ);
        Test ts = st.zero() ? this.test : (this.zero() ? st.test : Test.get(Arrays.asList(this.test, st.test)));
        return SeqType.get(tp, oc, ts);
    }

    public static SeqType union(Expr[] exprs, boolean zero) {
        SeqType st = null;
        for (Expr expr : exprs) {
            SeqType st2 = expr.seqType();
            if (!zero && st2.zero()) continue;
            st = st == null ? st2 : st.union(st2);
        }
        return st;
    }

    public SeqType intersect(SeqType st) {
        if (this == st) {
            return this;
        }
        Type tp = this.type.intersect(st.type);
        if (tp == null) {
            return null;
        }
        Occ oc = this.occ.intersect(st.occ);
        if (oc == null) {
            return null;
        }
        if (this.test == null || st.test == null || this.test.equals(st.test)) {
            return SeqType.get(tp, oc, this.test != null ? this.test : st.test);
        }
        Test kn = this.test.intersect(st.test);
        return kn == null ? null : SeqType.get(tp, oc, kn);
    }

    public boolean zeroOrOne() {
        return this.occ.max <= 1L;
    }

    public boolean zero() {
        return this.occ == Occ.ZERO;
    }

    public boolean one() {
        return this.occ == Occ.EXACTLY_ONE;
    }

    public boolean oneOrMore() {
        return this.occ.min >= 1L;
    }

    public boolean mayBeNumber() {
        return !this.zero() && (this.type.isNumber() || AtomType.ANY_ATOMIC_TYPE.instanceOf(this.type));
    }

    public boolean mayBeArray() {
        return !this.zero() && (this.type instanceof ArrayType || ARRAY.instanceOf(this.type));
    }

    public boolean mayBeStruct() {
        return !this.zero() && (this.type instanceof ArrayType || ARRAY.instanceOf(this.type) || this.type instanceof MapType || MAP.instanceOf(this.type));
    }

    public boolean mayBeFunction() {
        return !this.zero() && (this.type instanceof FType || this.type == AtomType.ITEM);
    }

    public boolean instanceOf(SeqType st) {
        if (this == st) {
            return true;
        }
        if (this.zero()) {
            return !st.oneOrMore();
        }
        if (!this.occ.instanceOf(st.occ)) {
            return false;
        }
        Type type = this.type;
        if (type instanceof ChoiceItemType) {
            ChoiceItemType cit = (ChoiceItemType)type;
            return cit.instanceOf(st.with(Occ.EXACTLY_ONE));
        }
        type = st.type;
        if (type instanceof ChoiceItemType) {
            ChoiceItemType cit = (ChoiceItemType)type;
            return cit.hasInstance(this.with(Occ.EXACTLY_ONE));
        }
        return this.type.instanceOf(st.type) && this.kindInstanceOf(st);
    }

    public boolean kindInstanceOf(SeqType st) {
        return st.test == null || this.test != null && this.test.instanceOf(st.test);
    }

    public Test test() {
        return this.test;
    }

    public boolean eq(SeqType st) {
        return this == st || this.type.eq(st.type) && this.occ == st.occ && Objects.equals(this.test, st.test);
    }

    public boolean equals(Object obj) {
        SeqType st;
        return this == obj || obj instanceof SeqType && this.eq(st = (SeqType)obj);
    }

    public int hashCode() {
        if (this.test != null) {
            throw Util.notExpected();
        }
        return (this.type == null ? 0 : this.type.hashCode()) + (this.occ == null ? 0 : this.occ.hashCode());
    }

    public String typeString() {
        return this.zero() ? "empty-sequence()" : (this.test != null ? this.test.toString() : this.type.toString());
    }

    public String toString() {
        TokenBuilder tb = new TokenBuilder();
        if (!this.one() && this.type instanceof FType) {
            tb.add(40).add(this.typeString()).add(41);
        } else {
            tb.add(this.typeString());
        }
        if (!(this.type instanceof ListType)) {
            tb.add((Object)this.occ);
        }
        return tb.toString();
    }

    static {
        TokenObjectMap<RecordField> map = new TokenObjectMap<RecordField>(2L);
        map.put(Str.KEY.string(), new RecordField(false, ANY_ATOMIC_TYPE_O));
        map.put(Str.VALUE.string(), new RecordField(false, ITEM_ZM));
        PAIR = new RecordType(true, map, null);
        map = new TokenObjectMap(1L);
        map.put(Str.VALUE.string(), new RecordField(false, ITEM_ZM));
        MEMBER = new RecordType(true, map, null);
        RECORD_O = RECORD.seqType();
        PAIR_O = PAIR.seqType();
        PAIR_ZM = PAIR.seqType(Occ.ZERO_OR_MORE);
        MEMBER_ZM = MEMBER.seqType(Occ.ZERO_OR_MORE);
    }
}

