/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.Token;
import org.basex.util.hash.ASet;

public class TokenSet
extends ASet
implements Iterable<byte[]> {
    protected byte[][] keys;

    public TokenSet() {
        this(2L);
    }

    public TokenSet(long capacity) {
        super(capacity);
        this.keys = new byte[this.capacity()][];
    }

    public TokenSet(byte[] ... keys) {
        this(keys.length);
        for (byte[] key : keys) {
            this.add(key);
        }
    }

    public TokenSet(String ... keys) {
        this(keys.length);
        for (String key : keys) {
            this.add(key);
        }
    }

    public TokenSet(DataInput in) throws IOException {
        this.read(in);
    }

    public void read(DataInput in) throws IOException {
        this.keys = in.readTokens();
        this.next = in.readNums();
        this.buckets = in.readNums();
        this.size = in.readNum();
    }

    public void write(DataOutput out) throws IOException {
        out.writeTokens(this.keys);
        out.writeNums(this.next);
        out.writeNums(this.buckets);
        out.writeNum(this.size);
    }

    public final boolean add(byte[] key) {
        return this.store(key) > 0;
    }

    public final boolean add(String key) {
        return this.add(Token.token(key));
    }

    public final int put(byte[] key) {
        int index = this.store(key);
        return Math.abs(index);
    }

    public final boolean contains(byte[] key) {
        return this.index(key) > 0;
    }

    public final int index(byte[] key) {
        int b = Token.hashCode(key) & this.capacity() - 1;
        int i = this.buckets[b];
        while (i != 0) {
            if (Token.eq(key, this.keys[i])) {
                return i;
            }
            i = this.next[i];
        }
        return 0;
    }

    public final byte[] key(int index) {
        return this.keys[index];
    }

    public int remove(byte[] key) {
        int b = Token.hashCode(key) & this.capacity() - 1;
        int p = 0;
        int i = this.buckets[b];
        while (i != 0) {
            if (Token.eq(key, this.keys[i])) {
                if (p == 0) {
                    this.buckets[b] = this.next[i];
                } else {
                    this.next[p] = this.next[this.next[p]];
                }
                this.keys[i] = null;
                return i;
            }
            p = i;
            i = this.next[i];
        }
        return 0;
    }

    private int store(byte[] key) {
        int h = Token.hashCode(key);
        int b = h & this.capacity() - 1;
        int i = this.buckets[b];
        while (i != 0) {
            if (Token.eq(key, this.keys[i])) {
                return -i;
            }
            i = this.next[i];
        }
        int s = this.size++;
        if (this.checkCapacity()) {
            b = h & this.capacity() - 1;
        }
        this.next[s] = this.buckets[b];
        this.keys[s] = key;
        this.buckets[b] = s;
        return s;
    }

    @Override
    protected final int hashCode(int index) {
        return Token.hashCode(this.keys[index]);
    }

    @Override
    protected void rehash(int newSize) {
        this.keys = Array.copyOf(this.keys, newSize);
    }

    @Override
    public void clear() {
        Arrays.fill((Object[])this.keys, null);
        super.clear();
    }

    @Override
    public final Iterator<byte[]> iterator() {
        return new ArrayIterator<byte[]>((Object[])this.keys, 1, this.size);
    }

    public final byte[][] keys() {
        return (byte[][])Arrays.copyOfRange(this.keys, 1, this.size);
    }

    public String toString() {
        return this.toString((Object[])this.keys);
    }
}

