/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Open;
import org.basex.core.jobs.Job;
import org.basex.core.locks.LockList;
import org.basex.core.locks.Locks;
import org.basex.core.users.Perm;
import org.basex.http.HTTPConnection;
import org.basex.http.HTTPException;
import org.basex.http.HTTPStatus;
import org.basex.http.rest.RESTSession;
import org.basex.io.out.ArrayOutput;
import org.basex.query.QueryException;
import org.basex.util.options.Options;

abstract class RESTCmd
extends Command {
    final RESTSession session;
    HTTPStatus status;

    RESTCmd(RESTSession session) {
        super(Perm.NONE, new String[0]);
        this.session = session;
        this.jc().type("REST");
    }

    public void addLocks() {
        Locks locks = this.jc().locks;
        LockList reads = locks.reads;
        LockList writes = locks.writes;
        for (Command cmd : this.session) {
            cmd.addLocks();
            Locks cmdLocks = cmd.jc().locks;
            if (cmdLocks.writes.contains("internal:context")) {
                writes.add(reads);
            }
            reads.add(cmdLocks.reads);
            writes.add(cmdLocks.writes);
        }
    }

    public boolean updating(Context ctx) {
        boolean up = false;
        for (Command cmd : this.session) {
            up |= cmd.updating(ctx);
        }
        this.updating = up;
        return up;
    }

    protected final boolean run() {
        try {
            this.run0();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            boolean bl = this.error(ex.getMessage(), new Object[0]);
            return bl;
        }
        finally {
            Close.close((Context)this.context);
        }
    }

    protected abstract void run0() throws IOException;

    final String run(Command cmd) throws HTTPException {
        ArrayOutput ao = new ArrayOutput();
        this.run(cmd, (OutputStream)ao);
        return ao.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void run(Command cmd, OutputStream os) throws HTTPException {
        try {
            boolean ok = ((Command)this.pushJob((Job)cmd)).run(this.context, os);
            String info = cmd.info();
            this.error(info, new Object[0]);
            if (!ok) {
                if (cmd instanceof Open) {
                    this.status = HTTPStatus.NOT_FOUND_X;
                }
                throw HTTPStatus.BAD_REQUEST_X.get(info);
            }
        }
        finally {
            this.popJob();
        }
    }

    static void assignOptions(RESTSession session) throws QueryException, IOException {
        HTTPConnection conn = session.conn;
        for (Map.Entry<String, String[]> entry : conn.requestCtx.queryStrings().entrySet()) {
            RESTCmd.assign((Options)conn.context.options, entry, true);
        }
    }

    static boolean assign(Options options, Map.Entry<String, String[]> entry, boolean enforce) throws HTTPException {
        String key = entry.getKey();
        if (options instanceof MainOptions) {
            key = key.toUpperCase(Locale.ENGLISH);
        }
        if (options.option(key) == null) {
            if (enforce) {
                throw HTTPStatus.UNKNOWN_PARAM_X.get(key);
            }
            return false;
        }
        try {
            options.assign(key, entry.getValue()[0]);
            return true;
        }
        catch (BaseXException ex) {
            throw HTTPStatus.BAD_REQUEST_X.get(new Object[]{ex});
        }
    }
}

