/*
 * Decompiled with CFR 0.152.
 */
package net.reduls.igo.dictionary;

import java.io.IOException;
import net.reduls.igo.dictionary.ViterbiNode;
import net.reduls.igo.trie.Searcher;
import net.reduls.igo.util.FileMappedInputStream;

public final class WordDic {
    private final Searcher trie;
    private final String data;
    private final int[] indices;
    public final short[] costs;
    public final short[] leftIds;
    public final short[] rightIds;
    public final int[] dataOffsets;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WordDic(String string) throws IOException {
        this.trie = new Searcher(string + "/word2id");
        this.data = FileMappedInputStream.getString(string + "/word.dat");
        this.indices = FileMappedInputStream.getIntArray(string + "/word.ary.idx");
        FileMappedInputStream fileMappedInputStream = new FileMappedInputStream(string + "/word.inf");
        int n = fileMappedInputStream.size() / 10;
        try {
            this.dataOffsets = fileMappedInputStream.getIntArray(n);
            this.leftIds = fileMappedInputStream.getShortArray(n);
            this.rightIds = fileMappedInputStream.getShortArray(n);
            this.costs = fileMappedInputStream.getShortArray(n);
        }
        finally {
            fileMappedInputStream.close();
        }
    }

    public void search(CharSequence charSequence, int n, Callback callback) {
        this.trie.eachCommonPrefix(charSequence, n, new WordDicCallbackCaller(callback));
    }

    public void searchFromTrieId(int n, int n2, int n3, boolean bl, Callback callback) {
        int n4 = this.indices[n + 1];
        for (int i = this.indices[n]; i < n4; ++i) {
            callback.call(new ViterbiNode(i, n2, (short)n3, this.costs[i], this.leftIds[i], this.rightIds[i], bl));
        }
    }

    public String wordData(int n) {
        return this.data.substring(this.dataOffsets[n], this.dataOffsets[n + 1]);
    }

    public static interface Callback {
        public void call(ViterbiNode var1);

        public boolean isEmpty();
    }

    private class WordDicCallbackCaller
    implements Searcher.Callback {
        private final Callback fn;

        public WordDicCallbackCaller(Callback callback) {
            this.fn = callback;
        }

        @Override
        public void call(int n, int n2, int n3) {
            int n4 = WordDic.this.indices[n3 + 1];
            for (int i = WordDic.this.indices[n3]; i < n4; ++i) {
                this.fn.call(new ViterbiNode(i, n, (short)n2, WordDic.this.costs[i], WordDic.this.leftIds[i], WordDic.this.rightIds[i], false));
            }
        }
    }
}

