/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core;

import java.util.Enumeration;
import java.util.Properties;
import net.xqj.core.XQToolkit;
import org.xml.sax.Attributes;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXStringBuffer
extends DefaultHandler
implements LexicalHandler {
    private final StringBuffer buffer = new StringBuffer();
    private Properties namespaces = new Properties();
    private boolean hasContents = false;
    private boolean isFirstElement = true;

    @Override
    public void characters(char[] ch, int start, int length) {
        if (!this.hasContents) {
            this.buffer.append('>');
            this.hasContents = true;
        }
        block7: for (int i = 0; i < length; ++i) {
            char c = ch[start + i];
            switch (c) {
                case '&': {
                    this.buffer.append("&amp;");
                    continue block7;
                }
                case '<': {
                    this.buffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    this.buffer.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    this.buffer.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    this.buffer.append("&apos;");
                    continue block7;
                }
                default: {
                    this.buffer.append(c);
                }
            }
        }
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (this.hasContents) {
            this.buffer.append('<').append('/').append(qName).append('>');
        } else {
            this.buffer.append('/').append('>');
            this.hasContents = true;
        }
    }

    @Override
    public void processingInstruction(String target, String data) {
        this.buffer.append("<?").append(target).append(' ').append(data).append("?>");
        this.hasContents = true;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        if (!this.hasContents && !this.isFirstElement) {
            this.buffer.append('>');
        }
        this.buffer.append('<').append(qName);
        for (int i = atts.getLength() - 1; i >= 0; --i) {
            if (atts.getQName(i).equals("xmlns")) continue;
            this.buffer.append(' ').append(atts.getQName(i)).append('=');
            String quoted = XQToolkit.getInQuotes(atts.getValue(i));
            this.buffer.append(quoted);
        }
        if (this.isFirstElement) {
            Enumeration<?> e = this.namespaces.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                this.buffer.append(' ');
                this.buffer.append("xmlns");
                if (name.length() != 0) {
                    this.buffer.append(':').append(name);
                }
                this.buffer.append('=');
                String quoted = XQToolkit.getInQuotes((String)this.namespaces.get(name));
                this.buffer.append(quoted);
            }
            this.isFirstElement = false;
        } else if (this.getPrefixFromURI(uri) == null) {
            this.buffer.append(" xmlns=");
            String quoted = XQToolkit.getInQuotes(uri);
            this.buffer.append(quoted);
        }
        this.hasContents = false;
    }

    @Override
    public void comment(char[] ch, int start, int length) {
        this.buffer.append("<!--");
        this.buffer.append(ch, start, length);
        this.buffer.append("-->");
    }

    @Override
    public void endCDATA() {
        this.buffer.append("]]>");
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void endEntity(String name) {
    }

    @Override
    public void startCDATA() {
        this.buffer.append("<![CDATA[");
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) {
        this.buffer.append("<!DOCTYPE ");
        this.buffer.append(name);
        this.buffer.append(' ');
        if (publicId == null) {
            this.buffer.append("SYSTEM");
        } else {
            this.buffer.append("PUBLIC ").append(XQToolkit.getInQuotes(publicId));
        }
        this.buffer.append(' ').append(XQToolkit.getInQuotes(systemId)).append('>');
    }

    @Override
    public void startEntity(String name) {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (this.isFirstElement) {
            this.namespaces.put(prefix, uri);
        }
    }

    private String getPrefixFromURI(String uri) {
        Enumeration<?> e = this.namespaces.propertyNames();
        while (e.hasMoreElements()) {
            String prefix = (String)e.nextElement();
            String pUri = this.namespaces.getProperty(prefix);
            if (!pUri.equals(uri)) continue;
            return prefix;
        }
        return null;
    }

    public String toString() {
        return this.buffer.toString();
    }
}

