/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.xqitem;

import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.util.Properties;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQSequence;
import net.xqj.core.Constants;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.util.Logger;
import net.xqj.core.xqitem.XQItemBase;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class XQItemProxy
implements XQItem,
Cloneable {
    protected static int instanceCounter = 0;
    protected int instanceId = ++instanceCounter;
    protected Logger logger = Constants.EMPTY_LOGGER_INSTANCE;
    protected XQItemBase item = null;
    protected XQSequence sequence = null;
    protected boolean isClosed = false;

    protected XQItemProxy(XQItemBase item) {
        this.item = item;
    }

    static XQItemProxy newInstance(XQItemBase item) {
        return new XQItemProxy(item);
    }

    public boolean getBoolean() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(63, this));
        }
        return this.item.getBoolean();
    }

    public byte getByte() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(64, this));
        }
        return this.item.getByte();
    }

    public double getDouble() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(65, this));
        }
        return this.item.getDouble();
    }

    public float getFloat() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(66, this));
        }
        return this.item.getFloat();
    }

    public int getInt() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(67, this));
        }
        return this.item.getInt();
    }

    public XQItemType getItemType() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(68, this));
        }
        return this.item.getItemType();
    }

    public String getAtomicValue() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(69, this));
        }
        return this.item.getAtomicValue();
    }

    public long getLong() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(70, this));
        }
        return this.item.getLong();
    }

    public Node getNode() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(71, this));
        }
        return this.item.getNode();
    }

    public URI getNodeUri() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(72, this));
        }
        return this.item.getNodeUri();
    }

    public Object getObject() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(73, this));
        }
        return this.item.getObject();
    }

    public XMLStreamReader getItemAsStream() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(74, this));
        }
        return this.item.getItemAsStream();
    }

    public String getItemAsString(Properties properties) throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(75, this, properties));
        }
        return this.item.getItemAsString(properties);
    }

    public short getShort() throws XQException {
        this.isClosedCheck();
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(76, this));
        }
        return this.item.getShort();
    }

    public boolean instanceOf(XQItemType ancestor) throws XQException {
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(77, this, ancestor));
        }
        return this.item.instanceOf(ancestor);
    }

    public void writeItem(OutputStream out, Properties properties) throws XQException {
        this.isClosedCheck();
        XQToolkit.nullValueTest(out, "OutputStream", "XQJITP002");
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(78, this, out, properties));
        }
        this.item.writeItem(out, properties);
    }

    public void writeItem(Writer writer, Properties properties) throws XQException {
        this.isClosedCheck();
        XQToolkit.nullValueTest(writer, "Writer", "XQJITP003");
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(79, this, writer, properties));
        }
        this.item.writeItem(writer, properties);
    }

    public void writeItemToSAX(ContentHandler saxhdlr) throws XQException {
        this.isClosedCheck();
        XQToolkit.nullValueTest(saxhdlr, "ContentHandler", "XQJITP004");
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(80, this, saxhdlr));
        }
        this.item.writeItemToSAX(saxhdlr);
    }

    public void writeItemToResult(Result result) throws XQException {
        this.isClosedCheck();
        XQToolkit.nullValueTest(result, "Result", "XQJITP005");
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(81, this, result));
        }
        this.item.writeItemToResult(result);
    }

    public void close() throws XQException {
        if (this.logger.isDebugLoggable()) {
            this.logger.log(4, XQToolkit.formatMessage(13, this));
        }
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed || this.sequence != null && this.sequence.isClosed();
    }

    public void setXQItem(XQItemBase item) {
        this.item = item;
        this.isClosed = false;
    }

    public void setItemType(XQItemType xqItemType) {
        this.item.setItemType(xqItemType);
    }

    public String getItemTypeAsString() throws XQException {
        return this.item.getItemTypeAsString();
    }

    public void setNodeUri(String lexicalString) {
        this.item.setNodeUri(lexicalString);
    }

    public void isClosedCheck() throws XQException {
        if (this.isClosed) {
            throw new XQExceptionImpl("Can not perform this operation when the sequence is closed.", "XQJITP001");
        }
    }

    public XQItemBase getItemBase() {
        return this.item;
    }

    public String toString() {
        return "XQItemProxy-" + this.instanceId + "-(" + this.item + ")";
    }

    public Object clone() {
        try {
            XQItemProxy newProxy = (XQItemProxy)super.clone();
            newProxy.instanceId = ++instanceCounter;
            newProxy.item = (XQItemBase)this.item.clone();
            return newProxy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setSequence(XQSequence sequence) {
        this.sequence = sequence;
    }

    public XQSequence getSequence() {
        return this.sequence;
    }
}

