/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.util;

import java.io.IOException;
import java.io.Writer;
import net.xqj.core.TextContainer;

public class StringWriter
extends Writer {
    protected TextContainer buf;

    public StringWriter() {
        this(new TextContainer());
    }

    public StringWriter(TextContainer buffer) {
        this.buf = buffer;
    }

    @Override
    public final void write(int c) throws IOException {
        this.buf.append((char)c);
    }

    @Override
    public final void write(char[] cbuf, int off, int len) throws IOException {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.buf.append(cbuf, off, len);
    }

    @Override
    public final void write(char[] cbuf) throws IOException {
        this.buf.append(cbuf);
    }

    @Override
    public final void write(String str) throws IOException {
        this.buf.append(str.toCharArray());
    }

    @Override
    public final void write(String str, int off, int len) throws IOException {
        this.buf.append(str.substring(off, off + len).toCharArray());
    }

    public final String toString() {
        return new String(this.buf.toCharArray());
    }

    public final StringBuffer getBuffer() {
        return new StringBuffer(new String(this.buf.toCharArray()));
    }

    @Override
    public final void flush() {
    }

    public void setTextContainer(TextContainer textContainer) {
        this.buf = textContainer;
    }

    public TextContainer getTextContainer() {
        return this.buf;
    }

    @Override
    public final void close() throws IOException {
        this.buf = null;
    }

    public void reset() {
        this.buf.reset();
    }
}

