/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import org.basex.data.DataText;
import org.basex.gui.GUIConstants;
import org.basex.gui.text.Syntax;
import org.basex.gui.text.TextIterator;
import org.basex.query.QueryText;
import org.basex.query.expr.CmpN;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.path.Axis;
import org.basex.query.func.Functions;
import org.basex.query.util.NSGlobal;
import org.basex.query.value.item.QNm;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;

final class SyntaxXQuery
extends Syntax {
    private static final String OPENING = "{(";
    private static final String CLOSING = "})";
    private static final HashSet<String> KEYWORDS = new HashSet();
    private int comment;
    private int quote;
    private boolean var;
    private boolean elem;

    SyntaxXQuery() {
    }

    @Override
    public void init(Color color) {
        super.init(color);
        this.quote = 0;
        this.var = false;
        this.elem = false;
        this.comment = 0;
    }

    @Override
    public Color getColor(TextIterator iter) {
        int ch = iter.curr();
        if (this.quote != 0) {
            if (ch == this.quote) {
                this.quote = 0;
            }
            return GUIConstants.DGRAY;
        }
        if (this.comment == 0 && ch == 40) {
            ++this.comment;
        } else if (this.comment == 1) {
            this.comment = ch == 58 ? 2 : 0;
        } else if (this.comment == 2 && ch == 58) {
            ++this.comment;
        } else if (this.comment == 3 && ch != 58) {
            int n = this.comment = ch == 41 ? 0 : 2;
        }
        if (this.comment != 0) {
            this.var = false;
            return GUIConstants.GRAY;
        }
        if (ch == 34 || ch == 39 || ch == 96) {
            this.quote = ch;
            return GUIConstants.DGRAY;
        }
        if (ch == 36) {
            this.var = true;
            return GUIConstants.GREEN;
        }
        if (this.var) {
            this.var = XMLToken.isChar(ch);
            return GUIConstants.GREEN;
        }
        if (Token.digit(ch) && !Double.isNaN(Token.toDouble(Token.token(iter.currString())))) {
            return GUIConstants.PURPLE;
        }
        if (!XMLToken.isNCChar(ch)) {
            this.elem = ch == 60 || ch == 37;
            return GUIConstants.GRAY;
        }
        if (!this.elem && KEYWORDS.contains(iter.currString())) {
            return GUIConstants.BLUE;
        }
        this.elem = false;
        return this.plain;
    }

    @Override
    public byte[] commentOpen() {
        return DataText.XQCOMM_O;
    }

    @Override
    public byte[] commentEnd() {
        return DataText.XQCOMM_C;
    }

    @Override
    public byte[] format(byte[] text, byte[] spaces) {
        TokenBuilder tb = new TokenBuilder();
        int tl = text.length;
        byte quoted = 0;
        int comments = 0;
        int indents = 0;
        for (int t = 0; t < tl; ++t) {
            byte prev;
            byte curr = text[t];
            int open = OPENING.indexOf(curr);
            int close = CLOSING.indexOf(curr);
            byte next = t + 1 < tl ? text[t + 1] : (byte)0;
            byte by = prev = t > 0 ? text[t - 1] : (byte)0;
            if (quoted != 0) {
                if (curr == quoted) {
                    quoted = 0;
                }
            } else if ("\"'`".indexOf(curr) != -1) {
                quoted = curr;
            } else if (curr == 40 && next == 58) {
                ++comments;
            } else if (prev == 58 && curr == 41) {
                --comments;
            } else if (comments == 0) {
                int i;
                if (open != -1) {
                    ++indents;
                    tb.addByte(curr);
                    if (next == 10 || SyntaxXQuery.matches(CLOSING.charAt(open), t, text, true)) continue;
                    tb.add(10);
                    for (i = 0; i < indents; ++i) {
                        tb.add(spaces);
                    }
                    continue;
                }
                if (close != -1) {
                    --indents;
                    if (!SyntaxXQuery.endingWithWs(tb) && !SyntaxXQuery.matches(OPENING.charAt(close), t, text, false)) {
                        tb.add(10);
                        for (i = 0; i < indents; ++i) {
                            tb.add(spaces);
                        }
                    }
                }
            }
            tb.addByte(curr);
        }
        return tb.finish();
    }

    private static boolean endingWithWs(TokenBuilder text) {
        byte c;
        for (int t = text.size() - 1; t >= 0 && (c = text.get(t)) != 10; --t) {
            if (Token.ws(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean matches(char ch, int pos, byte[] text, boolean after) {
        int dist = after ? 3 : -3;
        int d = 0;
        while (after ? d < dist : d > dist) {
            int p = pos + d;
            if (p >= 0 && p < text.length && text[p] == ch) {
                return true;
            }
            d += after ? 1 : -1;
        }
        return false;
    }

    static {
        try {
            for (Field field : QueryText.class.getFields()) {
                if ("IGNORE".equals(field.getName())) break;
                Collections.addAll(KEYWORDS, ((String)field.get(null)).split("-"));
            }
            for (QNm name : Functions.BUILT_IN) {
                Collections.addAll(KEYWORDS, Token.string(name.local()).split("-"));
            }
            for (Axis axis : Axis.values()) {
                Collections.addAll(KEYWORDS, axis.name);
            }
            for (CmpV.OpV opV : CmpV.OpV.values()) {
                Collections.addAll(KEYWORDS, opV.name);
            }
            for (CmpN.OpN opN : CmpN.OpN.values()) {
                Collections.addAll(KEYWORDS, opN.names[0]);
            }
            Atts ns = NSGlobal.NS;
            for (int n = 0; n < ns.size(); ++n) {
                KEYWORDS.add(Token.string(ns.name(n)));
            }
        }
        catch (Exception ex) {
            Util.stack(ex);
        }
    }
}

