/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.func.Function;
import org.basex.query.value.Value;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class CItemArray
extends Single {
    public CItemArray(InputInfo info, Expr expr) {
        super(info, expr, Types.ARRAY_O);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        long size = this.expr.size();
        if (size == 0L) {
            return XQArray.empty();
        }
        if (size == 1L) {
            return cc.replaceWith(this, cc.function(Function._UTIL_ARRAY_MEMBER, this.info, this.expr));
        }
        this.exprType.assign(ArrayType.get(this.expr.seqType().with(Occ.EXACTLY_ONE)));
        return this.expr instanceof Value ? cc.preEval(this) : this;
    }

    @Override
    public XQArray item(QueryContext qc, InputInfo ii) throws QueryException {
        return XQArray.items(this.expr.value(qc));
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr ex = this;
        if (mode.oneOf(CompileContext.Simplify.NUMBER, CompileContext.Simplify.DATA)) {
            ex = this.expr.simplifyFor(mode, cc);
        }
        return cc.simplify(this, ex, mode);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new CItemArray(this.info, this.expr.copy(cc, vm)));
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof CItemArray && super.equals(obj);
    }

    @Override
    public long structSize() {
        return this.expr.size();
    }

    @Override
    public String description() {
        return "curly array constructor";
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("array").brace(this.expr);
    }
}

