/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import org.basex.data.Data;
import org.basex.index.resource.ResourceType;
import org.basex.index.resource.Resources;
import org.basex.io.IOFile;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.db.DbAccessFn;
import org.basex.query.value.item.Bln;
import org.basex.util.Checks;
import org.basex.util.InputInfo;

public final class DbExists
extends DbAccessFn {
    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        return Bln.get(this.test(qc, ii, 0L));
    }

    @Override
    public boolean test(QueryContext qc, InputInfo ii, long pos) throws QueryException {
        try {
            Data data = this.toData(qc);
            String path = this.toDbPathOrNull(this.arg(1), qc);
            if (path == null) {
                return true;
            }
            Checks<ResourceType> exists = type -> {
                IOFile bin = data.meta.file(path, (ResourceType)((Object)type));
                return bin != null && bin.exists() && !bin.isDir();
            };
            return data.resources.doc(path) != -1 || exists.any((ResourceType[])Resources.BINARIES);
        }
        catch (QueryException ex) {
            if (ex.error() == QueryError.DB_GET2_X) {
                return false;
            }
            throw ex;
        }
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        try {
            return this.compileData(cc);
        }
        catch (QueryException ex) {
            if (ex.error() == QueryError.DB_GET2_X) {
                return Bln.FALSE;
            }
            throw ex;
        }
    }
}

