/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.random;

import java.util.Random;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.DblSeq;
import org.basex.query.value.seq.Seq;
import org.basex.util.list.DoubleList;

public final class RandomSeededDouble
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        final long[] args = this.args(qc);
        return new Iter(){
            final Random r;
            long c;
            {
                this.r = new Random(args[0]);
                this.c = args[1];
            }

            @Override
            public Item next() {
                return --this.c >= 0L ? Dbl.get(this.r.nextDouble()) : null;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        long[] args = this.args(qc);
        Random r = new Random(args[0]);
        int vl = Seq.initialCapacity(args[1]);
        DoubleList values = new DoubleList(vl);
        for (long v = 0L; v < (long)vl; ++v) {
            values.add(r.nextDouble());
        }
        return DblSeq.get(values.finish());
    }

    private long[] args(QueryContext qc) throws QueryException {
        long seed = this.toLong(this.arg(0), qc);
        long num = this.toLong(this.arg(1), qc);
        if (num < 0L) {
            throw QueryError.RANGE_NEGATIVE_X.get(this.info, num);
        }
        return new long[]{seed, num};
    }
}

