/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.util.Objects;
import org.basex.core.MainOptions;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.java.JavaCall;
import org.basex.query.util.DeepEqual;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.Types;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class XQJava
extends FItem {
    private final Object value;

    public XQJava(Object value) {
        super(Types.JAVA);
        this.value = value;
    }

    @Override
    public AnnList annotations() {
        return AnnList.EMPTY;
    }

    @Override
    public Value invokeInternal(QueryContext qc, InputInfo ii, Value[] args) throws QueryException {
        return JavaCall.toValue(this.value, qc, ii, MainOptions.WrapOptions.NONE);
    }

    @Override
    public byte[] string(InputInfo ii) {
        return Token.token(Objects.toString(this.value));
    }

    @Override
    public int stackFrameSize() {
        return 0;
    }

    @Override
    public int arity() {
        return 0;
    }

    @Override
    public QNm funcName() {
        String name = this.value != null ? this.value.getClass().getCanonicalName() : null;
        return new QNm(QueryText.JAVA_PREFIX, name != null ? name.replace("[]", "...") : "null", QueryText.JAVA_URI);
    }

    @Override
    public String funcIdentity() {
        return new TokenBuilder(this.funcName().prefixId()).add(45).addInt(this.hashCode()).toString();
    }

    @Override
    public QNm paramName(int pos) {
        return null;
    }

    @Override
    public Expr inline(Expr[] exprs, CompileContext cc) {
        return null;
    }

    @Override
    public boolean vacuousBody() {
        return false;
    }

    @Override
    boolean updating() {
        return false;
    }

    @Override
    public FItem coerceTo(FuncType ft, QueryContext qc, CompileContext cc, InputInfo ii) throws QueryException {
        if (this.type.instanceOf(ft)) {
            return this;
        }
        throw QueryError.typeError(this, ft, ii);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean deepEqual(Item item, DeepEqual deep) {
        if (this == item) return true;
        if (!(item instanceof XQJava)) return false;
        XQJava java = (XQJava)item;
        if (!Objects.equals(this.value, java.value)) return false;
        return true;
    }

    @Override
    public Object toJava() {
        return this.value;
    }

    @Override
    public void toString(QueryString qs) {
        qs.quoted(this.string(null));
    }
}

