/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;

public class AndArtifactFilter
implements ArtifactFilter {
    private Set<ArtifactFilter> filters;

    public AndArtifactFilter() {
        this.filters = new LinkedHashSet<ArtifactFilter>();
    }

    public AndArtifactFilter(List<ArtifactFilter> filters) {
        this.filters = new LinkedHashSet<ArtifactFilter>(filters);
    }

    @Override
    public boolean include(Artifact artifact) {
        boolean include = true;
        Iterator<ArtifactFilter> i = this.filters.iterator();
        while (i.hasNext() && include) {
            ArtifactFilter filter2 = i.next();
            if (filter2.include(artifact)) continue;
            include = false;
        }
        return include;
    }

    public void add(ArtifactFilter artifactFilter) {
        this.filters.add(artifactFilter);
    }

    public List<ArtifactFilter> getFilters() {
        return new ArrayList<ArtifactFilter>(this.filters);
    }

    public int hashCode() {
        int hash2 = 17;
        hash2 = hash2 * 31 + this.filters.hashCode();
        return hash2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AndArtifactFilter)) {
            return false;
        }
        AndArtifactFilter other = (AndArtifactFilter)obj;
        return this.filters.equals(other.filters);
    }
}

