name: Confidentiality Policy
acronym: CP
satisfies:
  TSC:
    - C1.1
    - C1.2
majorRevisions:
  - date: Jun 1 2018
    comment: Initial document
---

# Purpose and Scope

a. This policy outlines expected behavior of employees to keep confidential information about clients, partners, and our company secure. 

a. This policy applies to all employees, board members, investors, and contractors, who may have access to confidential information. This policy must be made readily available to all whom it
applies to.

# Background

a. The company's confidential information must be protected for two reasons:

    i. It may be legally binding (i.e. sensitive customer data)

    i. It may be fundamental to our business (i.e. business processes) 

a. Common examples of confidential information in our company includes, but is not limited to: 

    i. Unpublished financial information

    i. Customer/partner/vendor/external party data

    i. Patents, formulas, new technologies, and other intellectual property

    i. Existing and prospective customer lists

    i. Undisclosed business strategies including pricing & marketing

    i. Materials & processes explicitly marked as “confidential”
	
a. Employees will have varying levels of authorized access to confidential information. 

# Policy

a. *Employee procedure for handling confidential information*

    i. Lock and secure confidential information at all times

    i. Safely dispose (i.e. shred) documents when no longer needed

    i. View confidential information only on secure devices

    i. Disclose information only when authorized and necessary

    i. Do not use confidential information for personal gain, benefit, or profit

    i. Do not disclose confidential information to anyone outside the company or to anyone within the company who does not have appropriate privileges 

    i. Do not store confidential information or replicates of confidential information in unsecured manners (i.e. on unsecured devices) 

    i. Do not remove confidential documents from company's premises unless absolutely necessary to move 

a. *Offboarding measures*

    i. The Hiring Manager should confirm the off-boarding procedure has been completed by final date of employment. 

a. *Confidentiality measures*

    i. The company will take the following measures to ensure protection of confidential information: 

        1. Store and lock paper documents

        1. Encrypt electronic information and implement appropriate technical measures to safeguard databases

        1. Require employees to sign non-disclosure/non-compete agreements

        1. Consult with senior management before granting employees access to certain confidential information 

a. *Exceptions*

    i. Under certain legitimate conditions, confidential information may need to be disclosed. Examples include: 

        1. If a regulatory agency requests information as part of an audit or investigation

        1. If the company requires disclosing information (within legal bounds) as part of a venture or partnership

    i. In such cases, employee must request and receive prior written authorization from their hiring manager before disclosing confidential information to any third parties.

a. *Disciplinary consequences* 

    i. Employees who violate the confidentiality policy will face disciplinary and possible legal action. 

    i. A suspected breach of this policy will trigger an investigation. Intentional violations will be met with termination and repeated unintentional violations may also face termination. 

    i. This policy is binding even after the termination of employment. 




  