name: Information Security Policy
acronym: ISP
satisfies:
  TSC:
    - CC9.9
majorRevisions:
  - date: Jun 1 2018
    comment: Initial document
---

# Purpose and Scope

a. This information security policy defines the purpose, principles, objectives and basic rules for information security management.

a. This document also defines procedures to implement high level information security protections within the organization, including definitions, procedures, responsibilities and performance measures (metrics and reporting mechanisms).

a. This policy applies to all users of information systems within the organization. This typically includes employees and contractors, as well as any external parties that come into contact with systems and information controlled by the organization (hereinafter referred to as “users”). This policy must be made readily available to all users.

# Background

a. This policy defines the high level objectives and implementation instructions for the organization’s information security program. It includes the organization’s information security objectives and requirements; such objectives and requirements are to be referenced when setting detailed information security policy for other areas of the organization. This policy also defines management roles and responsibilities for the organization’s Information Security Management System (ISMS). Finally, this policy references all security controls implemented within the organization.

a. Within this document, the following definitions apply:

    i. *Confidentiality*: a characteristic of information or information systems in which such information or systems are only available to authorized entities.

    i. *Integrity*: a characteristic of information or information systems in which such information or systems may only be changed by authorized entities, and in an approved manner.

    i. *Availability*: a characteristic of information or information systems in which such information or systems can be accessed by authorized entities whenever needed.

    i. *Information Security*: the act of preserving the confidentiality, integrity, and, availability of information and information systems.

    i. *Information Security Management System (ISMS)*: the overall management process that includes the planning, implementation, maintenance, review, and, improvement of information security.

# References

a. Encryption Policy

a. Data Center Security Policy

a. Disaster Recovery Policy

a. Password Policy

a. Remote Access Policy

a. Removable Media/Cloud Storage/BYOD Policy

a. Risk Assessment Policy

a. Security Incident Response Policy

a. Software Development Lifecycle Policy

a. System Availability Policy

a. Workstation Security Policy 

# Policy

a. *Managing Information Security*

    i. The organization’s main objectives for information security include the following:

        1. [list the reasons/objectives for maintaining information security at the organization. Examples include a better market image, reduced risk of data breaches and compromises, and compliance with legal, regulatory, and contractual requirements.]

    i. The organization’s objectives for information security are in line with the organization’s business objectives, strategy, and plans.

    i. Objectives for individual security controls or groups of controls are proposed by the company management team, including but not limited to [list key roles inside the organization that will participate in information security matters], and others as appointed by the CEO; these security controls are approved by the CEO in accordance with the Risk Assessment Policy (Reference (a)).

    i. All objectives must be reviewed at least once per year.

    i. The company will measure the fulfillment of all objectives. The measurement will be performed at least once per year. The results must be analyzed, evaluated, and reported to the management team.

a. *Information Security Requirements* 

    i. This policy and the entire information security program must be compliant with legal and regulatory requirements as well as with contractual obligations relevant to the organization.

    i. All employees, contractors, and other individuals subject to the organization’s information security policy must read and acknowledge all information security policies.

    i. The process of selecting information security controls and safeguards for the organization is defined in Reference (a).

    i. The organization prescribes guidelines for remote workers as part of the Remote Access Policy (reference (b)).

    i. To counter the risk of unauthorized access, the organization maintains a Data Center Security Policy (reference (c)).

    i. Security requirements for the software development life cycle, including system development, acquisition and maintenance are defined in the Software Development Lifecycle Policy (reference (d)).

    i. Security requirements for handling information security incidents are defined in the Security Incident Response Policy (reference (e)).

    i. Disaster recovery and business continuity management policy is defined in the Disaster Recovery Policy (reference (f)).

    i. Requirements for information system availability and redundancy are defined in the System Availability Policy (reference (g)).
