name: Office Security Policy
acronym: OSP
satisfies:
  TSC:
    - CC6.4
majorRevisions:
  - date: Jun 1 2018
    comment: Initial document
---

# Purpose and Scope

a. This policy establishes the rules governing controls, monitoring, and removal of physical access to company’s facilities.

a. This policy applies to all staff, contractors, or third parties who require access to any physical location owned, operated, or otherwise occupied by the company. A separate policy exists for governing access to the company data center. 

# Policy

a. *Management responsibilities*

    i. Management shall ensure:

        1. appropriate entry controls are in place for secure areas

        1. security personnel, identification badges, or electronic key cards should be used to validate employee access to facilities

        1. confirm visitor & guest access procedure has been followed by host staff 
        
        1. management periodically reviews list of individuals with physical access to facilities 
        
        1. card access records and visitor logs are kept for a minimum of 90 days and are periodically reviewed for unusual activity 

a. *Key access & card systems*
      
    i. The following policies are applied to all facility access cards/keys:
    
        1. Access cards/keys shall not be shared or loaned to others
      
        1. Access cards/keys shall not have identifying information other than a return mail address
      
        1. Access cards/keys shall be returned to Human Resources when they are no longer needed
      
        1. Lost or stolen access cards/keys shall be reported immediately 
      
        1. If an employee changes to a role that no longer requires physical access or leaves the company, their access cards/keys will be suspended 
      
        1. Human Resources will regularly review physical security privileges and review access logs 

\pagebreak 

a. *Staff & contractor access procedure* 

    i. Access to physical locations is granted to employees and contractors based on individual job function and will be granted by Human Resources. 

    i. Any individual granted access to physical spaces will be issued a physical key or access key card. Key and card issuance is tracked by Human Resources and will be periodically reviewed. 

    i. In the case of termination, Human Resources should ensure immediate revocation of access 
(i.e. collection of keys, access cards, and any other asset used to enter facilities) through the offboarding procedure. 

a. *Visitor & guest access procedure*
	
    i. The following policies are applied to identification & authorization of visitors and guests:

        1. All visitors must request and receive written onsite authorization from a staff member. 

        1. Visitor access shall be tracked with a sign in/out log. The log shall contain:visitor’s name, firm represented, purpose of visit, and onsite personnel authorizing access

        1. The log shall be retained for a minimum of 90 days

        1. Visitors shall be given a badge or other identification that visibly distinguishes visitors from onsite personnel 

        1. Visitor badges shall be surrendered before leaving the facility

a. *Audit controls & management*

    i. Documented procedures and evidence of practice should be in place for this policy. Acceptable controls and procedures include:

        1. visitor logs

        1. access control procedures
        
        1. operational key-card access systems
        
        1. video surveillance systems (with retrievable data)
        
        1. ledgers if issuing physical keys 

a. *Enforcement*

    i. Employees, contractors, or third parties found in violation of this policy (whether intentional or accidental) may be subject to disciplinary action, including:
      
        1. reprimand
        
        1. loss of access to premises
        
        1. termination



