/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.dameng.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.dameng.DamengConstants;
import org.jkiss.dbeaver.ext.dameng.model.DamengDataFile;
import org.jkiss.dbeaver.ext.dameng.model.DamengDataSource;
import org.jkiss.dbeaver.ext.dameng.model.DamengUtils;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBPObjectWithLongId;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class DamengTablespace
implements DBPRefreshableObject,
DBPObjectStatistics,
DBPScriptObject,
DBPObjectWithLongId {
    private final DamengDataSource dataSource;
    private long id;
    private final String name;
    private Cache cache;
    private Type type;
    private Status status;
    private Long maxSize;
    private Long totalSize;
    private Integer fileNum;
    private String encryptName;
    private String encryptedKey;
    private Integer copyNum;
    private String sizeMode;
    private Integer optNode;
    private final Long usedSize;
    final FileCache fileCache = new FileCache();

    public DamengTablespace(DamengDataSource dataSource, JDBCResultSet dbResult) {
        this.dataSource = dataSource;
        this.id = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"ID");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"NAME");
        this.cache = (Cache)CommonUtils.valueOf(Cache.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CACHE"), (Enum)Cache.NORMAL);
        int typeValue = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"TYPE$");
        this.type = Type.values()[typeValue - 1];
        int statusValue = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"STATUS$");
        this.status = Status.values()[statusValue];
        this.maxSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MAX_SIZE");
        this.totalSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"TOTAL_SIZE");
        this.fileNum = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"FILE_NUM");
        this.encryptName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ENCRYPT_NAME");
        this.encryptedKey = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ENCRYPTED_KEY");
        this.copyNum = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"COPY_NUM");
        this.sizeMode = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SIZE_MODE");
        this.optNode = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"OPT_NODE");
        this.usedSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"USED_SIZE");
    }

    @Association
    public Collection<DamengDataFile> getFiles(DBRProgressMonitor monitor) throws DBException {
        return this.fileCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Property(viewable=true)
    public long getObjectId() {
        return this.id;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean hasStatistics() {
        return this.usedSize != null;
    }

    public long getStatObjectSize() {
        return this.usedSize;
    }

    public DBPPropertySource getStatProperties() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.fileCache.clearCache();
        return this;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public DamengDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true)
    public Status getStatus() {
        return this.status;
    }

    @Property(viewable=true)
    public Cache getCache() {
        return this.cache;
    }

    @Property(viewable=true)
    public Type getType() {
        return this.type;
    }

    @Property(viewable=true)
    public Long getMaxSize() {
        return this.maxSize;
    }

    @Property(viewable=true)
    public Long getTotalSize() {
        return this.totalSize;
    }

    @Property(viewable=true)
    public Integer getFileNum() {
        return this.fileNum;
    }

    @Property(viewable=true)
    public String getEncryptName() {
        return this.encryptName;
    }

    @Property(viewable=true)
    public String getEncryptedKey() {
        return this.encryptedKey;
    }

    @Property(viewable=true)
    public Integer getCopyNum() {
        return this.copyNum;
    }

    @Property(viewable=true)
    public String getSizeMode() {
        return this.sizeMode;
    }

    @Property(viewable=true)
    public Integer getOptNode() {
        return this.optNode;
    }

    @Property(viewable=true)
    public Long getUsedSize() {
        return this.usedSize;
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        return DamengUtils.getDDL(monitor, (DBSObject)this, DamengConstants.ObjectType.TABLESPACE, null);
    }

    public static enum Cache {
        NORMAL,
        KEEP;

    }

    static class FileCache
    extends JDBCObjectCache<DamengTablespace, DamengDataFile> {
        FileCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull DamengTablespace damengTablespace) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT df.* FROM V$TABLESPACE AS ts, V$DATAFILE AS df WHERE ts.ID = df.GROUP_ID AND ts.NAME = ?");
            dbStat.setString(1, damengTablespace.getName());
            return dbStat;
        }

        protected DamengDataFile fetchObject(@NotNull JDBCSession session, @NotNull DamengTablespace damengTablespace, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new DamengDataFile(damengTablespace, (ResultSet)resultSet);
        }
    }

    public static enum Status {
        ONLINE,
        OFFLINE,
        RES_OFFLINE,
        CORRUPT;

    }

    public static enum Type {
        PERMANENT,
        TEMPORARY;

    }
}

