/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.tasks.ui.view.TaskHandlerRun;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceMenuContributor;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

public class RecentTasksMenuContributor
extends DataSourceMenuContributor {
    private static final int MAX_ITEMS = 5;

    protected void fillContributionItems(List<IContributionItem> menuItems) {
        DBTTask[] tasks;
        DBPProject project = NavigatorUtils.getSelectedProject();
        if (project == null) {
            return;
        }
        DBTTask[] dBTTaskArray = tasks = (DBTTask[])Arrays.stream(project.getTaskManager().getAllTasks()).sorted(Comparator.comparing(DBTTask::getUpdateTime).reversed()).limit(5L).toArray(DBTTask[]::new);
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            final DBTTask task = dBTTaskArray[n2];
            DBPImage taskIcon = task.getType().getIcon();
            if (taskIcon == null) {
                taskIcon = DBIcon.TREE_TASK;
            }
            menuItems.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action(task.getName(), DBeaverIcons.getImageDescriptor((DBPImage)taskIcon)){

                public void run() {
                    TaskHandlerRun.runTask(task);
                }
            }, (boolean)false));
            ++n2;
        }
    }
}

