/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPAutoCloser;
import org.jkiss.dbeaver.model.DBPCloseableObject;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.utils.ArrayUtils;

public abstract class AbstractStatement<SESSION extends DBCSession>
implements DBCStatement,
DBPAutoCloser {
    private static final Log log = Log.getLog(AbstractStatement.class);
    @NotNull
    protected final SESSION connection;
    @Nullable
    private DBCExecutionSource statementSource;
    @Nullable
    private DBPCloseableObject[] executeFinalizer;

    public AbstractStatement(@NotNull SESSION session) {
        this.connection = session;
    }

    @NotNull
    public SESSION getSession() {
        return this.connection;
    }

    @Override
    @Nullable
    public DBCExecutionSource getStatementSource() {
        return this.statementSource;
    }

    @Override
    public void setStatementSource(@Nullable DBCExecutionSource source) {
        this.statementSource = source;
    }

    protected boolean isQMLoggingEnabled() {
        return true;
    }

    @Override
    public void close() throws DBException {
        if (this.isQMLoggingEnabled()) {
            long updateRowCount = 0L;
            try {
                updateRowCount = this.getUpdateRowCount();
            }
            catch (DBCException e) {
                log.debug(e);
            }
            QMUtils.getDefaultHandler().handleStatementClose(this, updateRowCount);
        }
        this.runCloseDependants();
    }

    @Override
    public void autoCloseDependant(@NotNull DBPCloseableObject dependent) {
        this.executeFinalizer = this.executeFinalizer == null ? new DBPCloseableObject[]{dependent} : (DBPCloseableObject[])ArrayUtils.add(DBPCloseableObject.class, (Object[])this.executeFinalizer, (Object)dependent);
    }

    public void runCloseDependants() throws DBException {
        block10: {
            if (this.executeFinalizer != null) {
                try {
                    if (this.executeFinalizer.length == 1) {
                        this.executeFinalizer[0].close();
                        break block10;
                    }
                    Throwable firstError = null;
                    DBPCloseableObject[] dBPCloseableObjectArray = this.executeFinalizer;
                    int n = this.executeFinalizer.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block11: {
                            DBPCloseableObject co = dBPCloseableObjectArray[n2];
                            try {
                                co.close();
                            }
                            catch (Throwable e) {
                                if (firstError != null) break block11;
                                firstError = e;
                            }
                        }
                        ++n2;
                    }
                    if (firstError != null) {
                        if (firstError instanceof DBException) {
                            DBException dbe = (DBException)firstError;
                            throw dbe;
                        }
                        throw new DBException("Internal error during statement close", firstError);
                    }
                }
                finally {
                    this.executeFinalizer = null;
                }
            }
        }
    }
}

