/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.edit;

import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;

public class SQLDatabasePersistActionAtomic
extends SQLDatabasePersistAction {
    private boolean makeAtomic;
    private boolean wasTransactional = false;

    public SQLDatabasePersistActionAtomic(String title, String script) {
        this(title, script, true);
    }

    public SQLDatabasePersistActionAtomic(String title, String script, boolean makeAtomic) {
        super(title, script, false);
        this.makeAtomic = makeAtomic;
    }

    @Override
    public void beforeExecute(DBCSession session) throws DBCException {
        DBCTransactionManager txnManager;
        super.beforeExecute(session);
        if (this.makeAtomic && (txnManager = DBUtils.getTransactionManager(session.getExecutionContext())) != null && txnManager.isSupportsTransactions() && !txnManager.isAutoCommit()) {
            txnManager.setAutoCommit(session.getProgressMonitor(), true);
            this.wasTransactional = true;
        }
    }

    @Override
    public void afterExecute(DBCSession session, Throwable error) throws DBCException {
        DBCTransactionManager txnManager;
        super.afterExecute(session, error);
        if (this.wasTransactional && (txnManager = DBUtils.getTransactionManager(session.getExecutionContext())) != null) {
            txnManager.setAutoCommit(session.getProgressMonitor(), false);
        }
    }
}

