/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.jkiss.dbeaver.model.preferences.DBPSettingsSection;

public class DialogSettingsDelegate
implements DBPSettingsSection {
    private final IDialogSettings dialogSettings;

    public DialogSettingsDelegate(IDialogSettings dialogSettings) {
        this.dialogSettings = dialogSettings;
    }

    public String getName() {
        return this.dialogSettings.getName();
    }

    public DBPSettingsSection getSection(String sectionName) {
        IDialogSettings section = this.dialogSettings.getSection(sectionName);
        return section == null ? null : new DialogSettingsDelegate(section);
    }

    public DBPSettingsSection[] getSections() {
        IDialogSettings[] sections = this.dialogSettings.getSections();
        if (sections == null) {
            return null;
        }
        DBPSettingsSection[] ss = new DBPSettingsSection[sections.length];
        int i = 0;
        while (i < sections.length) {
            ss[i] = new DialogSettingsDelegate(sections[i]);
            ++i;
        }
        return ss;
    }

    public DBPSettingsSection addNewSection(String name) {
        return new DialogSettingsDelegate(this.dialogSettings.addNewSection(name));
    }

    public void addSection(DBPSettingsSection section) {
        if (!(section instanceof DialogSettingsDelegate)) {
            throw new IllegalArgumentException("Section must extend DialogSettingsDelegate");
        }
        this.dialogSettings.addSection(((DialogSettingsDelegate)section).dialogSettings);
    }

    public String get(String key) {
        return this.dialogSettings.get(key);
    }

    public String[] getArray(String key) {
        return this.dialogSettings.getArray(key);
    }

    public boolean getBoolean(String key) {
        return this.dialogSettings.getBoolean(key);
    }

    public double getDouble(String key) throws NumberFormatException {
        return this.dialogSettings.getDouble(key);
    }

    public float getFloat(String key) throws NumberFormatException {
        return this.dialogSettings.getFloat(key);
    }

    public int getInt(String key) throws NumberFormatException {
        return this.dialogSettings.getInt(key);
    }

    public long getLong(String key) throws NumberFormatException {
        return this.dialogSettings.getLong(key);
    }

    public void put(String key, String[] value) {
        this.dialogSettings.put(key, value);
    }

    public void put(String key, double value) {
        this.dialogSettings.put(key, value);
    }

    public void put(String key, float value) {
        this.dialogSettings.put(key, value);
    }

    public void put(String key, int value) {
        this.dialogSettings.put(key, value);
    }

    public void put(String key, long value) {
        this.dialogSettings.put(key, value);
    }

    public void put(String key, String value) {
        this.dialogSettings.put(key, value);
    }

    public void put(String key, boolean value) {
        this.dialogSettings.put(key, value);
    }
}

