/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.editors.DB2ObjectType;
import org.jkiss.dbeaver.ext.db2.model.DB2Object;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2Trigger;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TriggerDepType;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class DB2TriggerDep
extends DB2Object<DB2Trigger> {
    private DB2TriggerDepType triggerDepType;
    private DB2Schema depSchema;
    private String depModuleId;
    private String tabAuth;
    private DBSObject depObject;

    public DB2TriggerDep(DBRProgressMonitor monitor, DB2Trigger db2Trigger, ResultSet resultSet) throws DBException {
        super(db2Trigger, JDBCUtils.safeGetString((ResultSet)resultSet, (String)"BNAME"), true);
        this.depModuleId = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"BMODULEID");
        this.tabAuth = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TABAUTH");
        this.triggerDepType = (DB2TriggerDepType)CommonUtils.valueOf(DB2TriggerDepType.class, (String)JDBCUtils.safeGetString((ResultSet)resultSet, (String)"BTYPE"));
        String depSchemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"BSCHEMA");
        DB2ObjectType db2ObjectType = this.triggerDepType.getDb2ObjectType();
        if (db2ObjectType != null) {
            this.depSchema = this.getDataSource().getSchema(monitor, depSchemaName);
            this.depObject = db2ObjectType.findObject(monitor, this.depSchema, this.getName());
        }
    }

    @Override
    @Property(viewable=true, id="Name", order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, order=2)
    public DB2TriggerDepType getTriggerDepType() {
        return this.triggerDepType;
    }

    @Property(viewable=true, order=3)
    public DB2Schema getDepSchema() {
        return this.depSchema;
    }

    @Property(viewable=true, order=4)
    public DBSObject getDepObject() {
        return this.depObject;
    }

    @Property(viewable=true)
    public String getDepModuleId() {
        return this.depModuleId;
    }

    @Property(viewable=true)
    public String getTabAuth() {
        return this.tabAuth;
    }
}

